/*
 * Decompiled with CFR 0.152.
 */
package drivecircle;

import com.kazina.j.KzIniFile;
import java.util.ArrayList;
import javax.swing.JComboBox;

public class HistoryList {
    private int historyCapacity = 32;
    private ArrayList<String> history = new ArrayList();

    public void add(String s) {
        if (s == null || s.isEmpty()) {
            throw new IllegalArgumentException("null\u307e\u305f\u306f\u7a7a\u6587\u5b57\u5217\u306f\u8ffd\u52a0\u3067\u304d\u307e\u305b\u3093\u3002");
        }
        int idx = this.history.indexOf(s);
        if (idx == -1) {
            this.history.add(0, s);
            this.truncate();
        } else {
            this.history.remove(idx);
            this.history.add(0, s);
        }
    }

    private void truncate() {
        while (this.history.size() > this.historyCapacity) {
            this.history.remove(this.history.size() - 1);
        }
    }

    public void assignTo(JComboBox comboBox, int visibleCount) {
        comboBox.removeAllItems();
        for (int i = 0; i < Math.min(this.history.size(), visibleCount); ++i) {
            comboBox.addItem(this.history.get(i));
        }
    }

    public void iniWrite(KzIniFile ini, String ident) {
        ini.writeInt(ident + ".count", this.history.size());
        for (int i = 0; i < this.history.size(); ++i) {
            ini.writeString(ident + "[" + i + "]", this.history.get(i));
        }
    }

    public void iniRead(KzIniFile ini, String ident) {
        int count = ini.readInt(ident + ".count", 0);
        for (int i = 0; i < count; ++i) {
            String s = ini.readString(ident + "[" + i + "]", null);
            if (s == null || s.isEmpty()) continue;
            this.history.add(s);
        }
    }
}

