/*
 * Decompiled with CFR 0.152.
 */
package drivecircle;

import drivecircle.graph.DirectoryGraph;
import drivecircle.graph.DirectoryScanListener;
import drivecircle.graph.DirectoryScanner;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.LayoutStyle;

public class ScanningDialog
extends JDialog {
    private static final int SCAN_MONITER_INTERVAL = 150;
    private String path;
    private byte maxDepth;
    private float centerHoleSize;
    private long startTime;
    private ScanResult result;
    private DirectoryScanner checker = null;
    private boolean scanning;
    private Thread scanThread = new Thread(){

        public void run() {
            ScanningDialog.this.scanning = true;
            ScanningDialog.this.checker = new DirectoryScanner(ScanningDialog.this.path, new DirectoryScanListener(){

                public void onScanFinished(DirectoryScanner scanner) {
                    if (scanner.getFinished() != null) {
                        ScanResult r = new ScanResult();
                        r.graph = scanner.getFinished().buildDirectoryGraph(ScanningDialog.this.maxDepth);
                        r.graph.centerHoleSize = ScanningDialog.this.centerHoleSize;
                        r.render(800);
                        ScanningDialog.this.result = r;
                    } else {
                        ScanningDialog.this.result = null;
                    }
                    ScanningDialog.this.scanning = false;
                    ScanningDialog.this.setVisible(false);
                }

                public void onScanCanceled(DirectoryScanner scanner) {
                    ScanningDialog.this.result = null;
                    ScanningDialog.this.scanning = false;
                    ScanningDialog.this.setVisible(false);
                }
            });
            ScanningDialog.this.startTime = System.currentTimeMillis();
            ScanningDialog.this.scanMonitor.start();
            ScanningDialog.this.checker.start();
        }
    };
    private Thread scanMonitor = new Thread(){

        public void run() {
            while (ScanningDialog.this.scanning) {
                if (!ScanningDialog.this.checker.done()) {
                    ScanningDialog.this.setCurrentMessage("\u4e0b\u8a18\u306e\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u3092\u30b9\u30ad\u30e3\u30f3\u3057\u3066\u3044\u307e\u3059", ScanningDialog.this.checker.getCurrentPath());
                } else {
                    ScanningDialog.this.setCurrentMessage("\u30b0\u30e9\u30d5\u3092\u30ec\u30f3\u30c0\u30ea\u30f3\u30b0\u3057\u3066\u3044\u307e\u3059", "");
                }
                try {
                    Thread.sleep(150L);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(ScanningDialog.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    };
    private JButton btnCancel;
    private JPanel jPanel1;
    private JLabel lblCurrentScan;
    private JLabel lblDepth;
    private JLabel lblDescription;
    private JLabel lblDirectory;
    private JProgressBar prgBuild;

    public ScanningDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.prgBuild.setStringPainted(true);
    }

    public static final ScanResult execute(JFrame owner, String path, byte depth, float centerHoleSize) {
        ScanningDialog dlg = new ScanningDialog((Frame)owner, true);
        dlg.setLocationRelativeTo(owner);
        dlg.setInfo(path, depth, centerHoleSize);
        dlg.setVisible(true);
        return dlg.result;
    }

    private void setInfo(String path, byte depth, float holeSize) {
        this.path = path;
        this.lblDirectory.setText("\u5bfe\u8c61\u30c7\u30a3\u30ec\u30af\u30c8\u30ea: " + path);
        this.maxDepth = depth;
        this.lblDepth.setText("\u30b9\u30ad\u30e3\u30f3\u3059\u308b\u6df1\u3055: " + depth);
        this.centerHoleSize = holeSize;
    }

    private void setCurrentMessage(String line1, String line2) {
        this.lblDescription.setText(line1);
        this.lblCurrentScan.setText(line2);
        long time = (System.currentTimeMillis() - this.startTime) / 1000L;
        this.prgBuild.setString("\u7d4c\u904e\u6642\u9593: " + time + " \u79d2");
    }

    private void cancel() {
        if (this.checker != null) {
            this.checker.cancel();
        }
    }

    private void initComponents() {
        this.lblDescription = new JLabel();
        this.lblCurrentScan = new JLabel();
        this.prgBuild = new JProgressBar();
        this.jPanel1 = new JPanel();
        this.btnCancel = new JButton();
        this.lblDirectory = new JLabel();
        this.lblDepth = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle("\u30b9\u30ad\u30e3\u30f3\u5b9f\u884c\u4e2d");
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                ScanningDialog.this.formWindowClosing(evt);
            }

            public void windowOpened(WindowEvent evt) {
                ScanningDialog.this.formWindowOpened(evt);
            }
        });
        this.lblDescription.setText("\u4e0b\u8a18\u306e\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u3092\u30b9\u30ad\u30e3\u30f3\u3057\u3066\u3044\u307e\u3059");
        this.lblCurrentScan.setText("\u30c7\u30a3\u30ec\u30af\u30c8\u30ea");
        this.lblCurrentScan.setMaximumSize(new Dimension(430, 13));
        this.prgBuild.setIndeterminate(true);
        this.jPanel1.setPreferredSize(new Dimension(100, 100));
        this.jPanel1.setLayout(new FlowLayout(1, 0, 0));
        this.btnCancel.setText("\u30ad\u30e3\u30f3\u30bb\u30eb");
        this.btnCancel.setMaximumSize(new Dimension(120, 32));
        this.btnCancel.setMinimumSize(new Dimension(120, 32));
        this.btnCancel.setPreferredSize(new Dimension(120, 32));
        this.btnCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ScanningDialog.this.btnCancelActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.btnCancel);
        this.lblDirectory.setText("\u5bfe\u8c61\u30c7\u30a3\u30ec\u30af\u30c8\u30ea:");
        this.lblDepth.setText("\u30b9\u30ad\u30e3\u30f3\u3059\u308b\u6df1\u3055:");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblDirectory, -1, 430, Short.MAX_VALUE).addComponent(this.lblDepth, -1, 430, Short.MAX_VALUE).addComponent(this.prgBuild, GroupLayout.Alignment.TRAILING, -2, 430, -2).addComponent(this.lblCurrentScan, -2, 430, -2).addComponent(this.jPanel1, -1, 430, Short.MAX_VALUE).addComponent(this.lblDescription, -2, 430, -2)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.lblDirectory).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblDepth).addGap(18, 18, 18).addComponent(this.lblDescription).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblCurrentScan, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.prgBuild, -2, 22, -2).addGap(18, 18, 18).addComponent(this.jPanel1, -2, 32, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void formWindowOpened(WindowEvent evt) {
        this.scanThread.start();
    }

    private void btnCancelActionPerformed(ActionEvent evt) {
        this.cancel();
        this.setVisible(false);
    }

    private void formWindowClosing(WindowEvent evt) {
        this.cancel();
    }

    public static final class ScanResult {
        public DirectoryGraph graph;
        public BufferedImage buffer = null;
        public BufferedImage bufferForMouseMove = null;

        private void render(int bufferSize) {
            if (this.graph == null) {
                return;
            }
            this.buffer = new BufferedImage(bufferSize, bufferSize, 2);
            Graphics2D g = (Graphics2D)this.buffer.getGraphics();
            g.setComposite(AlphaComposite.Src);
            g.setColor(new Color(0xFFFFFF, true));
            g.fillRect(0, 0, this.buffer.getWidth(), this.buffer.getHeight());
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            long st = System.currentTimeMillis();
            this.graph.draw(g, 0, 0, bufferSize, 0.5f, -0.4f / (float)this.graph.getMaxDepth(), 1.0f);
            this.graph.drawLines(g, 0, 0, bufferSize, new Color(0xFFFFFF, true));
            Logger.getLogger(ScanningDialog.class.getName()).info("\u30e1\u30a4\u30f3\u30d0\u30c3\u30d5\u30a1\u306e\u63cf\u753b\u306b\u304b\u304b\u3063\u305f\u6642\u9593: " + (System.currentTimeMillis() - st) + "msec");
            g.dispose();
            st = System.currentTimeMillis();
            int[] rgbArray = new int[bufferSize * bufferSize];
            this.buffer.getRGB(0, 0, bufferSize, bufferSize, rgbArray, 0, bufferSize);
            for (int i = 0; i < rgbArray.length; ++i) {
                int value = rgbArray[i] >>> 24 & 0xFF;
                value = (int)((float)value * 0.2f);
                value = 255 - value;
                rgbArray[i] = value | value << 8 | value << 16;
            }
            this.bufferForMouseMove = new BufferedImage(bufferSize, bufferSize, 1);
            this.bufferForMouseMove.setRGB(0, 0, bufferSize, bufferSize, rgbArray, 0, bufferSize);
            Logger.getLogger(ScanningDialog.class.getName()).info("\u30de\u30a6\u30b9\u79fb\u52d5\u7528\u30d0\u30c3\u30d5\u30a1\u306e\u4f5c\u6210\u306b\u304b\u304b\u3063\u305f\u6642\u9593: " + (System.currentTimeMillis() - st) + "msec");
        }

        public void dispose() {
            this.graph = null;
            this.buffer = null;
            this.bufferForMouseMove = null;
        }
    }
}

