/*
 * Decompiled with CFR 0.152.
 */
package drivecircle.graph;

import drivecircle.graph.DirectoryGraph;
import drivecircle.graph.DirectoryGraphPiece;
import drivecircle.graph.DirectoryScanner;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.logging.Logger;

public final class ScannedDirectory {
    public final String fullPath;
    public final long totalSize;
    private ArrayList<ScannedDirectory> children = new ArrayList();
    private final int fileCount;
    private final long fileTotalSize;
    private static final HashMap<File, ScannedDirectory> cache = new HashMap();

    ScannedDirectory(File _file, DirectoryScanner scanner) {
        assert (_file.isDirectory()) : "\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u4ee5\u5916\u3067ScannedDirectory\u3092\u751f\u6210";
        this.fullPath = _file.getAbsolutePath();
        scanner.setCurrentStatus(this.fullPath, true);
        long st = 0L;
        long ft = 0L;
        int fc = 0;
        File[] fileList = _file.listFiles();
        if (fileList != null) {
            for (int i = 0; i < fileList.length; ++i) {
                if (fileList[i].isDirectory()) {
                    ScannedDirectory sd = cache.get(fileList[i]);
                    if (sd == null) {
                        sd = new ScannedDirectory(fileList[i], scanner);
                        cache.put(fileList[i], sd);
                    }
                    this.children.add(sd);
                    st += sd.totalSize;
                } else {
                    ++fc;
                    long size = fileList[i].length();
                    ft += size;
                    st += size;
                }
                if (scanner.getCanceled()) break;
            }
        }
        this.totalSize = st;
        this.fileCount = fc;
        this.fileTotalSize = ft;
        if (!scanner.getCanceled()) {
            ScannedDirectory[] a = new ScannedDirectory[this.children.size()];
            this.children.toArray(a);
            Arrays.sort(a, new Comparator<ScannedDirectory>(){

                @Override
                public int compare(ScannedDirectory o1, ScannedDirectory o2) {
                    return (int)Math.signum(o2.totalSize - o1.totalSize);
                }
            });
            for (int i = 0; i < this.children.size(); ++i) {
                this.children.set(i, a[i]);
            }
        }
    }

    public DirectoryGraph buildDirectoryGraph(int maxDepth) {
        DirectoryGraph graph = new DirectoryGraph();
        int createCount = 0;
        String msg = "\u30b0\u30e9\u30d5\u4f5c\u6210\u5b8c\u4e86\uff1a" + (createCount += this.buildSub(graph, null, 0, maxDepth, 0.0, 360.0, true, 360.0)) + "\u500b\u306e" + DirectoryGraphPiece.class.getName() + "\u3092\u751f\u6210";
        Logger.getLogger(DirectoryGraphPiece.class.getName()).info(msg);
        return graph;
    }

    private int buildSub(DirectoryGraph graph, DirectoryGraphPiece parent, int level, int maxLevel, double start, double length, boolean isGroupStart, double groupEndAngle) {
        int ct = 1;
        DirectoryGraphPiece self = new DirectoryGraphPiece(parent, this.fullPath, this.children.size(), this.fileCount, this.totalSize, start, length, isGroupStart, groupEndAngle);
        graph.add(self, level);
        if (level == 0) {
            graph.rootDirectory = self;
        }
        if (level >= maxLevel) {
            return ct;
        }
        double subStart = start;
        double dirEnd = (double)(this.totalSize - this.fileTotalSize) * length / (double)this.totalSize;
        boolean isStart = true;
        for (ScannedDirectory child : this.children) {
            if (child.totalSize == 0L) continue;
            double subLength = (double)child.totalSize * length / (double)this.totalSize;
            ct += child.buildSub(graph, self, level + 1, maxLevel, subStart, subLength, isStart, dirEnd);
            isStart = false;
            subStart += subLength;
        }
        return ct;
    }
}

