/*
 * Decompiled with CFR 0.152.
 */
package drivecircle;

import com.kazina.j.KzImageSelection;
import com.kazina.j.KzIniFile;
import com.kazina.j.KzUtils;
import drivecircle.HistoryList;
import drivecircle.ImageSizeDialog;
import drivecircle.Main;
import drivecircle.ScanningDialog;
import drivecircle.ShowGraphPanel;
import drivecircle.ShowGraphPanelListener;
import drivecircle.graph.DirectoryGraph;
import drivecircle.graph.DirectoryGraphPiece;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileNameExtensionFilter;

public class MainWindow
extends JFrame
implements ItemListener,
ShowGraphPanelListener {
    private static final String IDENT_WINDOW_POS = "Window";
    private static final String IDENT_STARTANGLE = "StartAngle";
    private static final String IDENT_COUNTERCLOCKWIZE = "CounterClockWize";
    private static final String IDENT_HISTORY = "History";
    private static final byte SCAN_DEPTH_MIN = 2;
    private static final byte SCAN_DEPTH_MAX = 8;
    private byte scanDepth;
    private float centerHoleSize;
    private static final int HISTORY_VISIBLE_COUNT_MAX = 32;
    private int historyVisibleCount;
    private static final int IMAGE_SIZE_MIN = 16;
    private static final int IMAGE_SIZE_MAX = 3000;
    private int outImageSize;
    private DirectoryGraph currentArcs = null;
    private final HistoryList history = new HistoryList();
    private JButton btnBrowse;
    private JButton btnGoUp;
    private JButton btnScan;
    private JComboBox cmbDirectory;
    private JButton jButton1;
    private JMenu jMenu1;
    private JMenu jMenu3;
    private JMenu jMenu4;
    private JMenuBar jMenuBar1;
    private JSeparator jSeparator1;
    private JToolBar jToolBar1;
    private JMenuItem mnuAbout;
    private JMenuItem mnuCopy;
    private JCheckBoxMenuItem mnuCounterClockWise;
    private JMenuItem mnuExit;
    private JMenuItem mnuKazinaCom;
    private JMenu mnuOutput;
    private JMenuItem mnuSaveAsPNG;
    private JMenu mnuScanDepth;
    private JMenuItem mnuStartAngle10;
    private JMenuItem mnuStartAngle11;
    private JMenuItem mnuStartAngle12;
    private JMenuItem mnuStartAngle9;
    private ShowGraphPanel pnlDonut;

    public MainWindow() {
        this.initComponents();
        this.setTitle(Main.appli.appName());
        this.setSize(500, 500);
        this.pnlDonut.setListener(this);
        ActionListener depthListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainWindow.this.scanDepth = Byte.parseByte(e.getActionCommand());
                if (MainWindow.this.currentArcs != null) {
                    MainWindow.this.rescan();
                }
            }
        };
        ButtonGroup group = new ButtonGroup();
        for (int i = 2; i <= 8; ++i) {
            String caption = "" + i;
            JRadioButtonMenuItem item = new JRadioButtonMenuItem(caption);
            item.setMnemonic(caption.charAt(0));
            item.setActionCommand(caption);
            item.addActionListener(depthListener);
            group.add(item);
            this.mnuScanDepth.add(item);
        }
        this.configLoad();
        group.setSelected(((JRadioButtonMenuItem)this.mnuScanDepth.getItem(this.scanDepth - 2)).getModel(), true);
        this.history.assignTo(this.cmbDirectory, this.historyVisibleCount);
        this.cmbDirectory.addItemListener(this);
        this.applyProp();
    }

    private final void configLoad() {
        try {
            KzIniFile ini = new KzIniFile(Main.appli.getApplicationConfigFileName());
            ini.readWindowPos(IDENT_WINDOW_POS, this);
            this.pnlDonut.startAngle = ini.readDouble(IDENT_STARTANGLE, -90.0);
            this.pnlDonut.counterClockWise = ini.readBool(IDENT_COUNTERCLOCKWIZE, false);
            this.centerHoleSize = Math.max(0.0f, Math.min(90.0f, ini.readFloat("centerHoleSize", 0.39655173f)));
            this.scanDepth = (byte)Math.max(2, Math.min(8, ini.readByte("ScanDepth", (byte)5)));
            this.outImageSize = Math.max(16, Math.min(3000, ini.readInt("ImageSize", 1024)));
            this.historyVisibleCount = Math.max(1, Math.min(ini.readInt("HistoryVisibleCount", 10), 32));
            this.history.iniRead(ini, IDENT_HISTORY);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private final void configSave() {
        try {
            KzIniFile ini = new KzIniFile(Main.appli.getApplicationConfigFileName());
            ini.writeWindowPos(IDENT_WINDOW_POS, this);
            ini.writeDouble(IDENT_STARTANGLE, this.pnlDonut.startAngle);
            ini.writeBool(IDENT_COUNTERCLOCKWIZE, this.pnlDonut.counterClockWise);
            ini.writeFloat("centerHoleSize", this.centerHoleSize);
            ini.writeByte("ScanDepth", this.scanDepth);
            ini.writeInt("ImageSize", this.outImageSize);
            ini.writeInt("HistoryVisibleCount", this.historyVisibleCount);
            this.history.iniWrite(ini, IDENT_HISTORY);
            ini.updateFile(Main.appli);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private boolean showImageSizeDialog() {
        int size = ImageSizeDialog.execute(this, this.outImageSize);
        if (size != -1) {
            this.outImageSize = size;
            return true;
        }
        return false;
    }

    private void applyProp() {
        if (this.currentArcs != null) {
            this.pnlDonut.repaint();
        }
        this.mnuCounterClockWise.setSelected(this.pnlDonut.counterClockWise);
    }

    private void scan(String path) {
        if (path == null || path.isEmpty()) {
            JOptionPane.showMessageDialog(this, "\u30b9\u30ad\u30e3\u30f3\u3059\u308b\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u3092\u6307\u5b9a\u3057\u3066\u4e0b\u3055\u3044\u3002", "\u30a8\u30e9\u30fc", 0);
            return;
        }
        Object newArc = null;
        ScanningDialog.ScanResult r = null;
        if (newArc == null) {
            File f = new File(path);
            if (!f.exists()) {
                JOptionPane.showMessageDialog(this, "\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002\n" + f.getAbsolutePath(), "\u30a8\u30e9\u30fc", 0);
            } else if (!f.isDirectory()) {
                JOptionPane.showMessageDialog(this, "\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u3067\u306f\u3042\u308a\u307e\u305b\u3093\u3002\n" + f.getAbsolutePath(), "\u30a8\u30e9\u30fc", 0);
            } else {
                r = ScanningDialog.execute(this, path, this.scanDepth, this.centerHoleSize);
            }
        }
        if (r != null) {
            this.currentArcs = r.graph;
            this.mnuOutput.setEnabled(true);
            this.pnlDonut.set(r);
            this.history.add(path);
            this.cmbDirectory.removeItemListener(this);
            this.history.assignTo(this.cmbDirectory, this.historyVisibleCount);
            this.cmbDirectory.addItemListener(this);
            r.dispose();
            r = null;
        }
    }

    private void rescan() {
        this.scan((String)this.cmbDirectory.getSelectedItem());
    }

    private BufferedImage getRenderedImage(int size, boolean alpha) {
        if (this.currentArcs != null) {
            BufferedImage imgResult;
            BufferedImage imgGraph = new BufferedImage(size, size, 2);
            Graphics2D g = (Graphics2D)imgGraph.getGraphics();
            g.setComposite(AlphaComposite.Src);
            g.setColor(new Color(0xFFFFFF, true));
            g.fillRect(0, 0, size, size);
            double tx = (double)size / 2.0;
            double ty = (double)size / 2.0;
            if (!this.pnlDonut.counterClockWise) {
                g.translate(tx, ty);
                g.scale(1.0, -1.0);
                g.translate(-tx, -ty);
            }
            g.rotate(Math.toRadians(this.pnlDonut.startAngle), tx, ty);
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this.currentArcs.draw(g, 0, 0, size, 0.5f, -0.4f / (float)this.currentArcs.getMaxDepth(), 1.0f);
            this.currentArcs.drawLines(g, 0, 0, size, new Color(0xFFFFFF, true));
            g.dispose();
            if (alpha) {
                imgResult = imgGraph;
            } else {
                imgResult = new BufferedImage(size, size, 1);
                Graphics2D gr = (Graphics2D)imgResult.getGraphics();
                gr.setColor(Color.WHITE);
                gr.fillRect(0, 0, size, size);
                gr.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                gr.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                gr.drawImage((Image)imgGraph, 0, 0, null);
                gr.dispose();
                imgGraph.flush();
            }
            return imgResult;
        }
        return null;
    }

    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.cmbDirectory && e.getStateChange() == 1) {
            this.scan((String)this.cmbDirectory.getSelectedItem());
        }
    }

    public void mouseMoved(DirectoryGraphPiece ds) {
    }

    public void onDoubleClickDirectory(DirectoryGraphPiece ds) {
        this.scan(ds.fullPath);
    }

    private void initComponents() {
        this.jButton1 = new JButton();
        this.jToolBar1 = new JToolBar();
        this.btnGoUp = new JButton();
        this.cmbDirectory = new JComboBox();
        this.btnBrowse = new JButton();
        this.btnScan = new JButton();
        this.pnlDonut = new ShowGraphPanel();
        this.jMenuBar1 = new JMenuBar();
        this.jMenu1 = new JMenu();
        this.mnuAbout = new JMenuItem();
        this.mnuKazinaCom = new JMenuItem();
        this.jSeparator1 = new JSeparator();
        this.mnuExit = new JMenuItem();
        this.mnuOutput = new JMenu();
        this.mnuCopy = new JMenuItem();
        this.mnuSaveAsPNG = new JMenuItem();
        this.jMenu3 = new JMenu();
        this.mnuScanDepth = new JMenu();
        this.jMenu4 = new JMenu();
        this.mnuStartAngle12 = new JMenuItem();
        this.mnuStartAngle10 = new JMenuItem();
        this.mnuStartAngle11 = new JMenuItem();
        this.mnuStartAngle9 = new JMenuItem();
        this.mnuCounterClockWise = new JCheckBoxMenuItem();
        this.jButton1.setText("jButton1");
        this.jButton1.setFocusable(false);
        this.jButton1.setHorizontalTextPosition(0);
        this.jButton1.setVerticalTextPosition(3);
        this.setDefaultCloseOperation(3);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                MainWindow.this.formWindowClosing(evt);
            }
        });
        this.jToolBar1.setFloatable(false);
        this.jToolBar1.setRollover(true);
        this.jToolBar1.setMaximumSize(new Dimension(32906, 40));
        this.jToolBar1.setMinimumSize(new Dimension(240, 40));
        this.jToolBar1.setPreferredSize(new Dimension(245, 40));
        this.btnGoUp.setIcon(new ImageIcon(this.getClass().getResource("/drivecircle/goup.png")));
        this.btnGoUp.setToolTipText("\u3072\u3068\u3064\u4e0a\u306e\u30d5\u30a9\u30eb\u30c0\u3078");
        this.btnGoUp.setFocusable(false);
        this.btnGoUp.setHorizontalTextPosition(0);
        this.btnGoUp.setMaximumSize(new Dimension(40, 40));
        this.btnGoUp.setMinimumSize(new Dimension(40, 40));
        this.btnGoUp.setPreferredSize(new Dimension(40, 40));
        this.btnGoUp.setVerticalTextPosition(3);
        this.btnGoUp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.btnGoUpActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.btnGoUp);
        this.cmbDirectory.setEditable(true);
        this.cmbDirectory.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.cmbDirectory.setMaximumSize(new Dimension(Short.MAX_VALUE, 20));
        this.cmbDirectory.setMinimumSize(new Dimension(101, 20));
        this.cmbDirectory.setPreferredSize(new Dimension(106, 20));
        this.jToolBar1.add(Box.createRigidArea(new Dimension(4, 4)));
        this.jToolBar1.add(this.cmbDirectory);
        this.jToolBar1.add(Box.createRigidArea(new Dimension(4, 4)));
        this.btnBrowse.setIcon(new ImageIcon(this.getClass().getResource("/drivecircle/folder.png")));
        this.btnBrowse.setToolTipText("\u53c2\u7167...");
        this.btnBrowse.setFocusable(false);
        this.btnBrowse.setHorizontalTextPosition(0);
        this.btnBrowse.setMaximumSize(new Dimension(40, 40));
        this.btnBrowse.setMinimumSize(new Dimension(40, 40));
        this.btnBrowse.setPreferredSize(new Dimension(40, 40));
        this.btnBrowse.setVerticalTextPosition(3);
        this.btnBrowse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.btnBrowseActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.btnBrowse);
        this.btnScan.setIcon(new ImageIcon(this.getClass().getResource("/drivecircle/loupe.png")));
        this.btnScan.setToolTipText("\u30b9\u30ad\u30e3\u30f3");
        this.btnScan.setFocusable(false);
        this.btnScan.setHorizontalTextPosition(0);
        this.btnScan.setMaximumSize(new Dimension(40, 40));
        this.btnScan.setMinimumSize(new Dimension(40, 40));
        this.btnScan.setPreferredSize(new Dimension(40, 40));
        this.btnScan.setVerticalTextPosition(3);
        this.btnScan.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.btnScanActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.btnScan);
        this.getContentPane().add((Component)this.jToolBar1, "First");
        this.getContentPane().add((Component)this.pnlDonut, "Center");
        this.jMenu1.setMnemonic('F');
        this.jMenu1.setText("\u30d5\u30a1\u30a4\u30eb(F)");
        this.mnuAbout.setAccelerator(KeyStroke.getKeyStroke(112, 0));
        this.mnuAbout.setMnemonic('A');
        this.mnuAbout.setText("\u30d0\u30fc\u30b8\u30e7\u30f3\u60c5\u5831(A)...");
        this.mnuAbout.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.mnuAboutActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.mnuAbout);
        this.mnuKazinaCom.setMnemonic('k');
        this.mnuKazinaCom.setText("kazina.com\u3078");
        this.mnuKazinaCom.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.mnuKazinaComActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.mnuKazinaCom);
        this.jMenu1.add(this.jSeparator1);
        this.mnuExit.setMnemonic('X');
        this.mnuExit.setText("\u7d42\u4e86(X)");
        this.mnuExit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.mnuExitActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.mnuExit);
        this.jMenuBar1.add(this.jMenu1);
        this.mnuOutput.setMnemonic('O');
        this.mnuOutput.setText("\u51fa\u529b(O)");
        this.mnuOutput.setEnabled(false);
        this.mnuCopy.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        this.mnuCopy.setMnemonic('C');
        this.mnuCopy.setText("\u30af\u30ea\u30c3\u30d7\u30dc\u30fc\u30c9\u306b\u30b3\u30d4\u30fc(C)...");
        this.mnuCopy.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.mnuCopyActionPerformed(evt);
            }
        });
        this.mnuOutput.add(this.mnuCopy);
        this.mnuSaveAsPNG.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.mnuSaveAsPNG.setMnemonic('A');
        this.mnuSaveAsPNG.setText("\u540d\u524d\u3092\u4ed8\u3051\u3066\u4fdd\u5b58(A)...");
        this.mnuSaveAsPNG.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.mnuSaveAsPNGActionPerformed(evt);
            }
        });
        this.mnuOutput.add(this.mnuSaveAsPNG);
        this.jMenuBar1.add(this.mnuOutput);
        this.jMenu3.setMnemonic('P');
        this.jMenu3.setText("\u8a2d\u5b9a(P)");
        this.mnuScanDepth.setMnemonic('D');
        this.mnuScanDepth.setText("\u30b9\u30ad\u30e3\u30f3\u3059\u308b\u6df1\u3055(D)");
        this.jMenu3.add(this.mnuScanDepth);
        this.jMenu4.setMnemonic('A');
        this.jMenu4.setText("\u958b\u59cb\u89d2\u5ea6(A)");
        this.mnuStartAngle12.setAccelerator(KeyStroke.getKeyStroke(38, 2));
        this.mnuStartAngle12.setMnemonic('1');
        this.mnuStartAngle12.setText("12\u6642\u65b9\u5411");
        this.mnuStartAngle12.setActionCommand("-90.0");
        this.mnuStartAngle12.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.mnuStartAngle12ActionPerformed(evt);
            }
        });
        this.jMenu4.add(this.mnuStartAngle12);
        this.mnuStartAngle10.setAccelerator(KeyStroke.getKeyStroke(39, 2));
        this.mnuStartAngle10.setMnemonic('3');
        this.mnuStartAngle10.setText("3\u6642\u65b9\u5411");
        this.mnuStartAngle10.setActionCommand("0.0");
        this.mnuStartAngle10.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.mnuStartAngle12ActionPerformed(evt);
            }
        });
        this.jMenu4.add(this.mnuStartAngle10);
        this.mnuStartAngle11.setAccelerator(KeyStroke.getKeyStroke(40, 2));
        this.mnuStartAngle11.setMnemonic('6');
        this.mnuStartAngle11.setText("6\u6642\u65b9\u5411");
        this.mnuStartAngle11.setActionCommand("180.0");
        this.mnuStartAngle11.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.mnuStartAngle12ActionPerformed(evt);
            }
        });
        this.jMenu4.add(this.mnuStartAngle11);
        this.mnuStartAngle9.setAccelerator(KeyStroke.getKeyStroke(37, 2));
        this.mnuStartAngle9.setMnemonic('9');
        this.mnuStartAngle9.setText("9\u6642\u65b9\u5411");
        this.mnuStartAngle9.setActionCommand("90.0");
        this.mnuStartAngle9.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.mnuStartAngle12ActionPerformed(evt);
            }
        });
        this.jMenu4.add(this.mnuStartAngle9);
        this.jMenu3.add(this.jMenu4);
        this.mnuCounterClockWise.setMnemonic('C');
        this.mnuCounterClockWise.setSelected(true);
        this.mnuCounterClockWise.setText("\u53cd\u6642\u8a08\u56de\u308a\u306b\u3059\u308b(C)");
        this.mnuCounterClockWise.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainWindow.this.mnuCounterClockWiseActionPerformed(evt);
            }
        });
        this.jMenu3.add(this.mnuCounterClockWise);
        this.jMenuBar1.add(this.jMenu3);
        this.setJMenuBar(this.jMenuBar1);
        this.pack();
    }

    private void mnuStartAngle12ActionPerformed(ActionEvent evt) {
        this.pnlDonut.startAngle = Double.parseDouble(evt.getActionCommand());
        this.applyProp();
    }

    private void mnuAboutActionPerformed(ActionEvent evt) {
        Main.appli.aboutDialog(this);
    }

    private void mnuKazinaComActionPerformed(ActionEvent evt) {
        KzUtils.kazinaCom();
    }

    private void mnuExitActionPerformed(ActionEvent evt) {
        System.exit(0);
    }

    private void btnBrowseActionPerformed(ActionEvent evt) {
        File dir = KzUtils.directorySelectDialog(this, (String)this.cmbDirectory.getSelectedItem());
        if (dir != null) {
            this.scan(dir.getAbsolutePath());
        }
    }

    private void btnScanActionPerformed(ActionEvent evt) {
        this.scan((String)this.cmbDirectory.getSelectedItem());
    }

    private void btnGoUpActionPerformed(ActionEvent evt) {
        File f = new File((String)this.cmbDirectory.getSelectedItem());
        if (f.getParentFile() != null) {
            this.scan(f.getParentFile().getAbsolutePath());
        }
    }

    private void mnuCopyActionPerformed(ActionEvent evt) {
        if (this.currentArcs != null && this.showImageSizeDialog()) {
            BufferedImage img = this.getRenderedImage(this.outImageSize, false);
            KzImageSelection is = new KzImageSelection(img);
            this.getToolkit().getSystemClipboard().setContents(is, is);
            Logger.getLogger(MainWindow.class.getName()).info("\u30af\u30ea\u30c3\u30d7\u30dc\u30fc\u30c9\u306b\u753b\u50cf\u3092\u30b3\u30d4\u30fc \u30b5\u30a4\u30ba:" + this.outImageSize);
            img.flush();
        }
    }

    private void mnuCounterClockWiseActionPerformed(ActionEvent evt) {
        this.pnlDonut.counterClockWise = !this.pnlDonut.counterClockWise;
        this.applyProp();
    }

    private void formWindowClosing(WindowEvent evt) {
        this.configSave();
    }

    private void mnuSaveAsPNGActionPerformed(ActionEvent evt) {
        if (this.currentArcs != null && this.showImageSizeDialog()) {
            JFileChooser chooser = new JFileChooser("");
            FileNameExtensionFilter fPng = new FileNameExtensionFilter("PNG\u30d5\u30a1\u30a4\u30eb(*.png)", "PNG");
            FileNameExtensionFilter fBmp = new FileNameExtensionFilter("BMP\u30d5\u30a1\u30a4\u30eb(*.bmp)", "BMP");
            chooser.setAcceptAllFileFilterUsed(false);
            chooser.addChoosableFileFilter(fPng);
            chooser.addChoosableFileFilter(fBmp);
            chooser.setFileFilter(fPng);
            if (chooser.showSaveDialog(this) == 0) {
                boolean ok;
                File f = chooser.getSelectedFile();
                boolean bl = ok = !f.exists();
                if (f.exists()) {
                    String msg = "\u30d5\u30a1\u30a4\u30eb " + f.getAbsolutePath() + " \u306f\u65e2\u306b\u5b58\u5728\u3057\u307e\u3059\u3002\n" + "\u4e0a\u66f8\u304d\u3057\u3066\u3082\u3088\u308d\u3057\u3044\u3067\u3059\u304b\uff1f";
                    if (JOptionPane.showConfirmDialog(this, msg, "\u4e0a\u66f8\u304d\u306e\u78ba\u8a8d", 0, 2) == 0) {
                        ok = true;
                    } else {
                        Logger.getLogger(MainWindow.class.getName()).info("\u30e6\u30fc\u30b6\u30fc\u306b\u3088\u308b\u4e0a\u66f8\u304d\u306e\u30ad\u30e3\u30f3\u30bb\u30eb");
                    }
                }
                if (ok) {
                    try {
                        BufferedImage img = null;
                        String ext = null;
                        if (chooser.getFileFilter() == fPng) {
                            img = this.getRenderedImage(this.outImageSize, true);
                            ext = "png";
                        } else if (chooser.getFileFilter() == fBmp) {
                            img = this.getRenderedImage(this.outImageSize, false);
                            ext = "bmp";
                        }
                        if (img != null) {
                            if (!KzUtils.lowerCaseFileName(KzUtils.extractFileExt(f.getName())).equals(ext)) {
                                f = new File(f.getAbsolutePath() + "." + ext);
                            }
                            ImageIO.write((RenderedImage)img, ext, f);
                            Logger.getLogger(MainWindow.class.getName()).info(ext + "\u5f62\u5f0f\u3067\u4fdd\u5b58 \u30b5\u30a4\u30ba:" + this.outImageSize + " \u30d5\u30a1\u30a4\u30eb\u540d:" + f.getAbsolutePath());
                            img.flush();
                        }
                    }
                    catch (IOException ex) {
                        Logger.getLogger(MainWindow.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            }
        }
    }
}

