/*
 * Decompiled with CFR 0.152.
 */
package drivecircle;

import com.kazina.j.KzUtils;
import drivecircle.ScanningDialog;
import drivecircle.ShowGraphPanelListener;
import drivecircle.graph.DirectoryGraph;
import drivecircle.graph.DirectoryGraphPiece;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;

public final class ShowGraphPanel
extends JComponent
implements MouseListener,
MouseMotionListener {
    private static final int MARGIN = 8;
    public double startAngle;
    public boolean counterClockWise;
    private DirectoryGraph arcs = null;
    private int imageX;
    private int imageSize;
    private int imageY;
    private double dragStartTheta;
    private double dragStartAngle;
    private ShowGraphPanelListener listener = null;
    private DirectoryGraphPiece focusDirectory = null;
    private BufferedImage buffer = null;
    private BufferedImage bufferForMouseMove = null;

    public ShowGraphPanel() {
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void setListener(ShowGraphPanelListener _listener) {
        this.listener = _listener;
    }

    public void set(ScanningDialog.ScanResult a) {
        if (this.arcs != null) {
            this.arcs.clear();
            this.arcs = null;
            this.buffer.flush();
            this.bufferForMouseMove.flush();
            this.bufferForMouseMove = null;
            this.buffer = null;
        }
        this.arcs = a.graph;
        this.buffer = a.buffer;
        this.bufferForMouseMove = a.bufferForMouseMove;
        this.repaint();
    }

    private Point2D clientToBuffer(Point client) {
        double x = client.x - this.imageX;
        double y = client.y - this.imageY;
        x = x / (double)this.imageSize * (double)this.buffer.getWidth();
        y = y / (double)this.imageSize * (double)this.buffer.getHeight();
        AffineTransform t = new AffineTransform();
        double dx = (double)this.buffer.getWidth() / 2.0;
        double dy = (double)this.buffer.getHeight() / 2.0;
        t.rotate(Math.toRadians(-this.startAngle), dx, dy);
        if (!this.counterClockWise) {
            t.translate(dx, dy);
            t.scale(1.0, -1.0);
            t.translate(-dx, -dy);
        }
        return t.transform(new Point2D.Double(x, y), null);
    }

    private void drawOutlineText(Graphics g, String s, int x, int y) {
        g.setColor(Color.WHITE);
        g.drawString(s, x - 1, y);
        g.drawString(s, x + 1, y);
        g.drawString(s, x, y - 1);
        g.drawString(s, x, y + 1);
        g.setColor(this.focusDirectory == null ? Color.BLACK : Color.RED);
        g.drawString(s, x, y);
    }

    public void paint(Graphics g) {
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.arcs != null) {
            if (this.getWidth() > this.getHeight()) {
                this.imageSize = this.getHeight() - 16;
                this.imageX = (this.getWidth() - this.imageSize) / 2;
                this.imageY = 8;
            } else {
                this.imageSize = this.getWidth() - 16;
                this.imageX = 8;
                this.imageY = (this.getHeight() - this.imageSize) / 2;
            }
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            AffineTransform current = g2.getTransform();
            double dx = (double)this.imageX + (double)this.imageSize / 2.0;
            double dy = (double)this.imageY + (double)this.imageSize / 2.0;
            if (!this.counterClockWise) {
                g2.translate(dx, dy);
                g2.scale(1.0, -1.0);
                g2.translate(-dx, -dy);
            }
            g2.rotate(Math.toRadians(this.startAngle), dx, dy);
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            if (this.focusDirectory == null) {
                g2.drawImage(this.buffer, this.imageX, this.imageY, this.imageSize, this.imageSize, null);
            } else {
                g2.drawImage(this.bufferForMouseMove, this.imageX, this.imageY, this.imageSize, this.imageSize, null);
                DirectoryGraphPiece ds = this.focusDirectory;
                float s = 1.0f;
                float sd = 1.0f / (float)(ds.getLevel() - 1);
                while (ds != null) {
                    Color c = Color.getHSBColor(0.0f, s, 1.0f);
                    this.arcs.drawPiece(g2, this.imageX, this.imageY, this.imageSize, 0.0, true, ds, c);
                    ds = ds.parent;
                    s -= sd;
                }
            }
            g2.setTransform(current);
            String[] texts = new String[4];
            DirectoryGraphPiece ds = this.focusDirectory == null ? this.arcs.rootDirectory : this.focusDirectory;
            texts[0] = ds.fullPath;
            texts[1] = this.focusDirectory == null ? ShowGraphPanel.formatCountLabel(this.arcs.totalDirectoryCount, this.arcs.totalFileCount) : ShowGraphPanel.formatCountLabel(this.focusDirectory.directoryCount, this.focusDirectory.fileCount);
            texts[2] = KzUtils.smartByteSize(ds.fileSize);
            texts[3] = this.focusDirectory == null ? "" : KzUtils.smartPercentage((double)this.focusDirectory.fileSize / (double)this.arcs.rootDirectory.fileSize) + " %";
            FontMetrics fm = g.getFontMetrics();
            int space = 4;
            int ty = (this.getHeight() - (fm.getHeight() + 4) * texts.length - 4) / 2;
            g.setColor(Color.BLACK);
            for (String s : texts) {
                this.drawOutlineText(g, s, (this.getWidth() - fm.stringWidth(s)) / 2, ty + fm.getAscent());
                ty += 4 + fm.getHeight();
            }
        }
    }

    private static String formatCountLabel(int dirCount, int fileCount) {
        StringBuffer sb = new StringBuffer("");
        if (dirCount == 0) {
            sb.append("no directories");
        } else if (dirCount == 1) {
            sb.append("1 directory");
        } else {
            sb.append(dirCount + " directories");
        }
        sb.append(", ");
        if (fileCount == 0) {
            sb.append("no files");
        } else if (fileCount == 1) {
            sb.append("1 file");
        } else {
            sb.append(fileCount + " files");
        }
        return sb.toString();
    }

    public void mouseDragged(MouseEvent e) {
        if (this.arcs != null) {
            int x = e.getPoint().x - this.getWidth() / 2;
            int y = e.getPoint().y - this.getHeight() / 2;
            double theta = Math.atan2(y, x) - this.dragStartTheta;
            if (!this.counterClockWise) {
                theta = -theta;
            }
            this.startAngle = this.dragStartAngle + Math.toDegrees(theta);
            this.repaint();
        }
    }

    public void mouseMoved(MouseEvent e) {
        if (this.arcs != null) {
            DirectoryGraphPiece ds = null;
            Ellipse2D.Double graphCircle = new Ellipse2D.Double(this.imageX, this.imageY, this.imageSize, this.imageSize);
            if (graphCircle.contains(e.getPoint())) {
                Point2D pt2 = this.clientToBuffer(e.getPoint());
                ds = this.arcs.getDirectoryAt(pt2, 0, 0, this.buffer.getWidth());
            }
            this.focusDirectory = ds;
            this.repaint();
            if (this.listener != null) {
                this.listener.mouseMoved(ds);
            }
        }
    }

    public void mouseClicked(MouseEvent e) {
        Point2D pt2;
        DirectoryGraphPiece ds;
        if (e.getClickCount() == 2 && this.arcs != null && (ds = this.arcs.getDirectoryAt(pt2 = this.clientToBuffer(e.getPoint()), 0, 0, this.buffer.getWidth())) != null && this.listener != null) {
            this.listener.onDoubleClickDirectory(ds);
        }
    }

    public void mouseEntered(MouseEvent arg0) {
    }

    public void mouseExited(MouseEvent arg0) {
    }

    public void mousePressed(MouseEvent e) {
        this.requestFocusInWindow();
        if (this.arcs != null) {
            int x = e.getPoint().x - this.getWidth() / 2;
            int y = e.getPoint().y - this.getHeight() / 2;
            this.dragStartTheta = Math.atan2(y, x);
            this.dragStartAngle = this.startAngle;
        }
    }

    public void mouseReleased(MouseEvent e) {
        this.mouseMoved(e);
    }
}

