/*
 * Decompiled with CFR 0.152.
 */
package drivecircle.graph;

import drivecircle.graph.DirectoryGraphPiece;
import drivecircle.graph.DirectoryGraphRing;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.logging.Logger;

public class DirectoryGraph {
    public float centerHoleSize;
    public int totalDirectoryCount;
    public int totalFileCount;
    private final HashMap<Integer, DirectoryGraphRing> rings = new HashMap();
    private int maxDepth;
    public DirectoryGraphPiece rootDirectory;

    public void clear() {
        for (Integer key : this.rings.keySet()) {
            this.rings.get(key).destroy();
            this.rings.put(key, null);
        }
        this.rings.clear();
        this.maxDepth = 0;
        this.totalFileCount = 0;
        this.totalDirectoryCount = 0;
    }

    public DirectoryGraphPiece add(DirectoryGraphPiece piece, int level) {
        DirectoryGraphRing ring = this.rings.get(level);
        if (ring == null) {
            ring = new DirectoryGraphRing();
            this.rings.put(level, ring);
        }
        ring.add(piece);
        if (level > this.maxDepth) {
            this.maxDepth = level;
        }
        this.totalDirectoryCount += piece.directoryCount;
        this.totalFileCount += piece.fileCount;
        return piece;
    }

    public int getMaxDepth() {
        return this.maxDepth;
    }

    private double getRingWidth(int diameter) {
        return ((float)diameter - (float)diameter * this.centerHoleSize) / 2.0f / (float)this.maxDepth;
    }

    public Ellipse2D getCenterHole(int x, int y, int diameter) {
        double d = (double)diameter * (1.0 - (double)this.centerHoleSize) / 2.0;
        return new Ellipse2D.Double((double)x + d, (double)y + d, (double)diameter - d * 2.0, (double)diameter - d * 2.0);
    }

    public void draw(Graphics2D g, int x, int y, int diameter, float sStart, float sDelta, float brigtness) {
        int drawCount = 0;
        double ringWidth = this.getRingWidth(diameter);
        float saturation = sStart;
        for (int level = this.maxDepth; level >= 0; --level) {
            double d = (double)(this.maxDepth - level) * ringWidth;
            double subX = (double)x + d;
            double subY = (double)y + d;
            double subDiameter = (double)diameter - d * 2.0;
            DirectoryGraphRing ring = this.rings.get(level);
            if (ring != null) {
                drawCount += ring.draw(g, subX, subY, subDiameter, ringWidth, saturation, brigtness);
            }
            saturation += sDelta;
        }
        g.setColor(new Color(0xFFFFFF, true));
        g.setComposite(AlphaComposite.Src);
        g.fill(this.getCenterHole(x, y, diameter));
        Logger.getLogger(DirectoryGraph.class.getName()).info("\u63cf\u753b\u3057\u305f\u5f27: " + drawCount + "\u500b");
    }

    public void drawLines(Graphics2D g, int x, int y, int diameter, Color c) {
        double ringWidth = this.getRingWidth(diameter);
        for (int level = this.maxDepth; level > 0; --level) {
            double d = (double)(this.maxDepth - level) * ringWidth;
            double subX = (double)x + d;
            double subY = (double)y + d;
            double subDiameter = (double)diameter - d * 2.0;
            DirectoryGraphRing ring = this.rings.get(level);
            if (ring == null) continue;
            Area a = new Area();
            a.add(new Area(new Rectangle2D.Double(subX, subY, subDiameter, subDiameter)));
            Ellipse2D.Double sub = new Ellipse2D.Double();
            sub.setFrame(subX + ringWidth, subY + ringWidth, subDiameter - ringWidth * 2.0, subDiameter - ringWidth * 2.0);
            a.subtract(new Area(sub));
            g.setClip(a);
            ring.drawLines(g, subX, subY, subDiameter, c);
            g.setClip(null);
            if (level <= 1) continue;
            Ellipse2D.Double circle = new Ellipse2D.Double(subX + ringWidth - 0.5, subY + ringWidth - 0.5, subDiameter - ringWidth * 2.0 + 1.0, subDiameter - ringWidth * 2.0 + 1.0);
            g.setColor(c);
            g.setStroke(new BasicStroke(1.5f * (float)diameter / 1000.0f, 0, 0));
            g.draw(circle);
        }
    }

    public void drawPiece(Graphics2D g, int x, int y, int diameter, double startAngle, boolean counterClockWise, DirectoryGraphPiece focus, Color c) {
        double ringWidth = this.getRingWidth(diameter);
        for (int level = this.maxDepth; level >= 0; --level) {
            double d = (double)(this.maxDepth - level) * ringWidth;
            double subX = (double)x + d;
            double subY = (double)y + d;
            double subDiameter = (double)diameter - d * 2.0;
            DirectoryGraphRing ring = this.rings.get(level);
            if (ring != null && ring.drawPiece(g, subX, subY, subDiameter, startAngle, counterClockWise, focus, c)) break;
        }
    }

    public DirectoryGraphPiece getDirectoryAt(Point2D pt, int x, int y, int diameter) {
        double ringWidth = this.getRingWidth(diameter);
        DirectoryGraphPiece result = null;
        if (this.getCenterHole(x, y, diameter).contains(pt)) {
            return null;
        }
        for (int level = 0; level <= this.maxDepth; ++level) {
            double subX = (double)x + (double)(this.maxDepth - level) * ringWidth;
            double subY = (double)y + (double)(this.maxDepth - level) * ringWidth;
            double subDiameter = (double)diameter - (double)(this.maxDepth - level) * ringWidth * 2.0;
            DirectoryGraphRing ring = this.rings.get(level);
            if (ring != null && (result = ring.getDirectoryAt(pt, subX, subY, subDiameter)) != null) break;
        }
        return result;
    }
}

