/*
 * Decompiled with CFR 0.152.
 */
package drivecircle.graph;

import drivecircle.graph.DirectoryGraphPiece;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DirectoryGraphRing {
    private static final double DRAW_SKIP_MINIMUM_SPACE_ANGLE = 0.5;
    private static final double DRAW_SKIP_MINIMUM_ANGLE = 2.0;
    private static final double DRAW_SKIP_MINIMUM_LINE_DISTANCE = 4.0;
    private ArrayList<DirectoryGraphPiece> bands = new ArrayList();

    DirectoryGraphRing() {
    }

    DirectoryGraphPiece getDirectory(int index) {
        return this.bands.get(index);
    }

    public void destroy() {
        for (DirectoryGraphPiece band : this.bands) {
            band.destroy();
        }
        this.bands.clear();
        this.bands = null;
    }

    void add(DirectoryGraphPiece piece) {
        this.bands.add(piece);
    }

    int draw(Graphics2D g, double x, double y, double diameter, double ringWidth, float saturation, float brightness) {
        double onePixelArc = 360.0 / (diameter * Math.PI);
        int drawCount = 0;
        g.setColor(new Color(0xFFFFFF, true));
        g.setComposite(AlphaComposite.Src);
        double d = ringWidth + 1.0;
        g.fill(new Ellipse2D.Double(x + d, y + d, diameter - d * 2.0, diameter - d * 2.0));
        return drawCount += this.drawBands(this.bands, g, x, y, diameter, onePixelArc, saturation, brightness);
    }

    void drawLines(Graphics2D g, double x, double y, double diameter, Color c) {
        if (this.bands.size() <= 1) {
            return;
        }
        Line2D.Double line = new Line2D.Double();
        line.x1 = x + diameter / 2.0;
        line.y1 = y + diameter / 2.0;
        g.setColor(c);
        g.setStroke(new BasicStroke((float)((double)0.8f * diameter / 1000.0), 0, 0));
        for (DirectoryGraphPiece band : this.bands) {
            Arc2D.Double arc = new Arc2D.Double(x, y, diameter, diameter, band.start, 0.0, 2);
            Point2D pt = arc.getStartPoint();
            double distance = line.getP2().distance(pt);
            if (!(distance >= 4.0)) continue;
            line.x2 = pt.getX();
            line.y2 = pt.getY();
            g.draw(line);
        }
    }

    DirectoryGraphPiece getDirectoryAt(Point2D pt, double x, double y, double diameter) {
        Point2D tpt = pt;
        DirectoryGraphPiece result = null;
        for (DirectoryGraphPiece band : this.bands) {
            Arc2D.Double arc = new Arc2D.Double(x, y, diameter, diameter, band.start, band.length, 2);
            if (!arc.contains(tpt)) continue;
            result = band;
            break;
        }
        return result;
    }

    boolean drawPiece(Graphics2D g, double x, double y, double diameter, double startAngle, boolean counterClockWise, DirectoryGraphPiece focus, Color c) {
        AffineTransform current = g.getTransform();
        g.rotate(Math.toRadians(startAngle), x + diameter / 2.0, y + diameter / 2.0);
        if (!counterClockWise) {
            double tx = x + diameter / 2.0;
            double ty = y + diameter / 2.0;
            g.translate(tx, ty);
            g.scale(1.0, -1.0);
            g.translate(-tx, -ty);
        }
        boolean result = this.drawBandsFocused(this.bands, g, x, y, diameter, focus, c);
        g.setTransform(current);
        return result;
    }

    private int drawBands(ArrayList<DirectoryGraphPiece> bands, Graphics2D g, double x, double y, double diameter, double onePixelArc, float saturation, float brightness) {
        int drawCount = 0;
        Arcs sumArea = new Arcs(x, y, diameter, diameter);
        g.setComposite(AlphaComposite.Src);
        for (int i = 0; i < bands.size(); ++i) {
            DirectoryGraphPiece band = bands.get(i);
            double len = band.length + onePixelArc;
            if (len > band.groupEnd) {
                len = band.groupEnd;
            }
            double arcStart = band.start;
            Arc2D.Double arc = new Arc2D.Double(x, y, diameter, diameter, arcStart, len, 2);
            if (bands.size() == 1) {
                sumArea.add(arc);
                this.drawA(g, sumArea, saturation, brightness);
                ++drawCount;
                continue;
            }
            if ((band.isGroupStart || i == bands.size() - 1) && Math.abs(arcStart - sumArea.maxArc) > 0.5) {
                this.drawA(g, sumArea, saturation, brightness);
                ++drawCount;
            }
            sumArea.add(arc);
            if (!(sumArea.getAngleExtent() > 2.0)) continue;
            this.drawA(g, sumArea, saturation, brightness);
            ++drawCount;
        }
        return drawCount;
    }

    private void drawA(Graphics2D g, Arcs sum, float s, float b) {
        if (!sum.isEmpty()) {
            Arc2D a = sum.getShape();
            float hue = (float)(1.0 * Math.abs(a.getAngleStart())) / 360.0f;
            int intcolor = Color.HSBtoRGB(hue, s, b);
            Color c = new Color(intcolor |= 0xFF000000, true);
            g.setPaint(c);
            g.fill(a);
            sum.reset();
        }
    }

    private boolean drawBandsFocused(ArrayList<DirectoryGraphPiece> bands, Graphics2D g, double x, double y, double diameter, DirectoryGraphPiece focus, Color c) {
        boolean result = false;
        for (DirectoryGraphPiece band : bands) {
            if (focus != band) continue;
            Arc2D.Double arc = new Arc2D.Double(x, y, diameter, diameter, band.start, band.length, 2);
            g.setPaint(c);
            g.fill(arc);
            result = true;
            break;
        }
        return result;
    }

    private static final class Arcs {
        private final double x;
        private final double y;
        private final double width;
        private final double height;
        private double startAngle;
        private double maxArc;

        public Arcs(double _x, double _y, double _width, double _height) {
            this.x = _x;
            this.y = _y;
            this.width = _width;
            this.height = _height;
            this.reset();
        }

        public void reset() {
            this.maxArc = Double.NaN;
            this.startAngle = Double.NaN;
        }

        public void add(Arc2D arc) {
            if (Double.isNaN(this.startAngle)) {
                this.startAngle = arc.getAngleStart();
            }
            double d = arc.getAngleStart() + arc.getAngleExtent();
            if (Double.isNaN(this.maxArc)) {
                this.maxArc = d;
            } else if (d > this.maxArc) {
                this.maxArc = d;
            }
        }

        public Arc2D getShape() {
            if (this.isEmpty()) {
                return null;
            }
            return new Arc2D.Double(this.x, this.y, this.width, this.height, this.startAngle, this.getAngleExtent(), 2);
        }

        public double getAngleExtent() {
            return this.isEmpty() ? 0.0 : this.maxArc - this.startAngle;
        }

        public boolean isEmpty() {
            return Double.isNaN(this.startAngle);
        }
    }
}

