/*
 * Decompiled with CFR 0.152.
 */
package drivecircle.graph;

import drivecircle.graph.DirectoryScanListener;
import drivecircle.graph.ScannedDirectory;
import java.io.File;
import java.util.logging.Logger;

public final class DirectoryScanner
extends Thread {
    private final String scanPath;
    private final DirectoryScanListener listener;
    private boolean isCanceled;
    private String convertingPath;
    private boolean convertDone;
    private int convertCreateCount;
    private ScannedDirectory finished;

    public DirectoryScanner(String _path, DirectoryScanListener _listener) {
        super("DirectoryScanner");
        this.scanPath = _path;
        this.listener = _listener;
        this.isCanceled = false;
        this.convertDone = false;
        this.convertingPath = "";
        this.convertCreateCount = 0;
        this.finished = null;
    }

    void setCurrentStatus(String path, boolean increment) {
        this.convertingPath = path;
        if (increment) {
            ++this.convertCreateCount;
        }
    }

    public String getCurrentPath() {
        return this.convertingPath;
    }

    public boolean done() {
        return this.convertDone;
    }

    public void cancel() {
        this.isCanceled = true;
    }

    public boolean getCanceled() {
        return this.isCanceled;
    }

    public ScannedDirectory getFinished() {
        return this.finished;
    }

    public void run() {
        File f = new File(this.scanPath);
        if (f.exists() && (f.isDirectory() || f.isFile())) {
            ScannedDirectory root = new ScannedDirectory(f, this);
            this.convertDone = true;
            if (!this.isCanceled) {
                this.finished = root;
                String msg = this.convertCreateCount + "\u500b\u306e" + ScannedDirectory.class.getName() + "\u3092\u751f\u6210";
                Logger.getLogger(DirectoryScanner.class.getName()).info(msg);
                if (this.listener != null) {
                    this.listener.onScanFinished(this);
                }
            } else {
                String msg = this.convertCreateCount + "\u500b\u306e" + ScannedDirectory.class.getName() + "\u3092\u751f\u6210\u3057\u305f\u3068\u3053\u308d\u3067\u30ad\u30e3\u30f3\u30bb\u30eb";
                Logger.getLogger(DirectoryScanner.class.getName()).info(msg);
                if (this.listener != null) {
                    this.listener.onScanCanceled(this);
                }
            }
        }
    }
}

