/*
 * Decompiled with CFR 0.152.
 */
package komadoriki.logger;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class BenriDate {
    private Date value;
    private String defaultFormat = "yyyy/MM/dd";

    public BenriDate() {
        this.value = new Date();
    }

    public BenriDate(Date date) {
        this.value = date;
    }

    public void setDate(int y, int m, int d) {
        Calendar c = Calendar.getInstance();
        c.setTime(this.value);
        c.set(1, y);
        c.set(2, m - 1);
        c.set(5, d);
        this.value = c.getTime();
    }

    public void setTime(int h, int m, int s) {
        Calendar c = Calendar.getInstance();
        c.setTime(this.value);
        c.set(11, h);
        c.set(12, m);
        c.set(13, s);
        this.value = c.getTime();
    }

    public void setTime(int secondOfDay) {
        int h = secondOfDay / 60 / 60;
        int m = secondOfDay / 60 % 60;
        int s = secondOfDay % 60;
        this.setTime(h, m, s);
    }

    public int getSecondOfDay() {
        Calendar c = Calendar.getInstance();
        c.setTime(this.value);
        int h = c.get(11);
        int m = c.get(12);
        int s = c.get(13);
        return BenriDate.getSecondOfDay(h, m, s);
    }

    public static int getSecondOfDay(int h, int m, int s) {
        return h * 60 * 60 + m * 60 + s;
    }

    public boolean sameDay(BenriDate target) {
        SimpleDateFormat sf = new SimpleDateFormat("yyyyMMdd");
        return sf.format(this.value).equals(sf.format(target.value));
    }

    public String format(String s) {
        return new SimpleDateFormat(s).format(this.value);
    }

    public void decode(String str) {
        Pattern ptTime = Pattern.compile("(\\d{2}):(\\d{2}):(\\d{2})");
        Matcher mt = ptTime.matcher(str);
        if (mt.matches()) {
            int h = Integer.parseInt(mt.group(1));
            int m = Integer.parseInt(mt.group(2));
            int s = Integer.parseInt(mt.group(3));
            this.setTime(h, m, s);
            return;
        }
        ptTime = Pattern.compile("(\\d{4})-(\\d{2})-(\\d{2})");
        mt = ptTime.matcher(str);
        if (mt.matches()) {
            int y = Integer.parseInt(mt.group(1));
            int m = Integer.parseInt(mt.group(2));
            int d = Integer.parseInt(mt.group(3));
            this.setDate(y, m, d);
            return;
        }
        throw new IllegalArgumentException("\u300c" + str + "\u300d\u306f\u6642\u523b\u306b\u5909\u63db\u3067\u304d\u307e\u305b\u3093\u3002");
    }

    public boolean equals(Object arg0) {
        return arg0 != null && arg0 instanceof BenriDate && this.value.equals(((BenriDate)arg0).value);
    }

    public String toString() {
        return this.format(this.defaultFormat);
    }
}

