/*
 * Decompiled with CFR 0.152.
 */
package komadoriki.logger;

import java.util.Timer;
import java.util.TimerTask;
import komadoriki.logger.BenriDate;

abstract class Logger {
    private Timer timer = new Timer(true);
    private int interval;
    private Task task = null;
    private long prevCaptureTime = 0L;

    Logger() {
    }

    protected abstract void capture(BenriDate var1) throws Exception;

    public void captureNow(boolean checkInterval) throws Exception {
        if (checkInterval) {
            long elapsed;
            long l = elapsed = this.prevCaptureTime <= 0L ? Long.MAX_VALUE : System.currentTimeMillis() - this.prevCaptureTime;
            if (elapsed >= (long)(this.interval * 1000)) {
                this.prevCaptureTime = System.currentTimeMillis();
                this.capture(new BenriDate());
            }
        } else {
            this.capture(new BenriDate());
        }
    }

    public void setInterval(int sec) {
        this.interval = sec;
    }

    public void start() {
        if (this.task == null && this.interval > 0) {
            this.task = new Task();
            this.timer.scheduleAtFixedRate((TimerTask)this.task, 500L, (long)(this.interval * 1000));
        }
    }

    public void stop() {
        if (this.task != null) {
            this.task.cancel();
            this.task = null;
        }
    }

    public boolean isRunning() {
        return this.task != null;
    }

    private final class Task
    extends TimerTask {
        private Task() {
        }

        public void run() {
            try {
                Logger.this.captureNow(true);
            }
            catch (Exception e) {
                e.printStackTrace();
                Logger.this.stop();
            }
        }
    }
}

