/*
 * Decompiled with CFR 0.152.
 */
package komadoriki.logger;

import com.kazina.j.KzUtils;
import java.awt.AWTException;
import java.awt.HeadlessException;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.regex.Pattern;
import komadoriki.logger.BenriDate;
import komadoriki.logger.Logger;
import komadoriki.logger.ScreenShotOption;

public final class ScreenShotLogger
extends Logger {
    public static final Pattern PATTERN_SNAPSHOT_FILENAME = Pattern.compile("\\d{4}-\\d{2}-\\d{2}_(\\d{2})-(\\d{2})-(\\d{2})-\\d{4}\\.(jpg|png|bmp|gif)");
    public static final String REGEX_DAY_DIR = "(\\d{4})-(\\d{2})-(\\d{2})";
    private final String logPath;
    public final ScreenShotOption option = new ScreenShotOption();

    public ScreenShotLogger(String logDirectory) {
        this.logPath = KzUtils.includingPathDelimiter(logDirectory);
    }

    public static String getDateDirectoryName(BenriDate date) {
        return date.format("yyyy-MM-dd");
    }

    public static BufferedImage takeScreenShot() throws HeadlessException, AWTException {
        BufferedImage screenShot = new Robot().createScreenCapture(new Rectangle(Toolkit.getDefaultToolkit().getScreenSize()));
        return screenShot;
    }

    protected void capture(BenriDate now) throws IOException, HeadlessException, AWTException {
        File dirToday = new File(this.logPath + ScreenShotLogger.getDateDirectoryName(now));
        if (!dirToday.exists() && !dirToday.mkdirs()) {
            throw new IOException("\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u304c\u4f5c\u6210\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002\n" + dirToday);
        }
        BufferedImage screenShot = ScreenShotLogger.takeScreenShot();
        File f = new File(dirToday, now.format("yyyy-MM-dd_HH-mm-ss-SSSS") + "." + this.option.format.getExt());
        this.option.saveImage(screenShot, f);
        screenShot.flush();
    }
}

