/*
 * Decompiled with CFR 0.152.
 */
package komadoriki.logger;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;

public final class ScreenShotOption {
    public Format format = Format.JPG;
    private int compress = 80;
    private float scale = 0.8f;

    public void setCompress(int value) {
        assert (0 <= value && value <= 100) : "\u7bc4\u56f2\u5916\u306e\u5727\u7e2e\u7387";
        this.compress = value;
    }

    public int getCompress() {
        return this.compress;
    }

    public void setScale(float value) {
        assert (0.01f <= value && value <= 1.0f) : "\u7bc4\u56f2\u5916\u306e\u7e2e\u5c0f\u7387";
        this.scale = value;
    }

    public float getScale() {
        return this.scale;
    }

    public void saveImage(BufferedImage img, Object out) throws IOException {
        boolean ok;
        boolean bl = ok = out instanceof File || out instanceof OutputStream || out instanceof ImageOutputStream;
        if (!ok) {
            throw new IllegalArgumentException("\u6307\u5b9a\u3055\u308c\u305f\u30af\u30e9\u30b9\u3067\u306f\u51fa\u529b\u3067\u304d\u307e\u305b\u3093\u3002" + out.getClass());
        }
        Image scaled = null;
        if (this.scale != 1.0f) {
            int sw = Math.max(1, (int)((float)img.getWidth() * this.scale));
            int sh = Math.max(1, (int)((float)img.getHeight() * this.scale));
            scaled = new BufferedImage(sw, sh, 1);
            Graphics2D g = ((BufferedImage)scaled).createGraphics();
            if (this.scale < 1.0f) {
                g.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
                g.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
                g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                g.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
                g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
            }
            g.drawImage(img, 0, 0, sw, sh, null);
            g.dispose();
            img.flush();
            img = scaled;
        }
        switch (this.format) {
            case JPG: {
                ScreenShotOption.saveImageAsJpeg(img, out, (float)this.compress / 100.0f);
                break;
            }
            case BMP: {
                ScreenShotOption.saveImageAs("bmp", img, out);
                break;
            }
            case PNG: {
                ScreenShotOption.saveImageAs("png", img, out);
                break;
            }
            case GIF: {
                ScreenShotOption.saveImageAs("gif", img, out);
            }
        }
        if (scaled != null) {
            scaled.flush();
        }
    }

    private static void saveImageAsJpeg(BufferedImage img, Object out, float quality) throws IOException {
        ImageWriter writer = null;
        Iterator<ImageWriter> iter = ImageIO.getImageWritersByFormatName("jpg");
        if (iter.hasNext()) {
            writer = iter.next();
        }
        assert (writer != null) : "JPEG writer was not found.";
        ImageOutputStream ios = ImageIO.createImageOutputStream(out);
        writer.setOutput(ios);
        ImageWriteParam iwParam = writer.getDefaultWriteParam();
        iwParam.setCompressionMode(2);
        iwParam.setCompressionQuality(quality);
        writer.write(null, new IIOImage(img, null, null), iwParam);
        ios.flush();
        writer.dispose();
        ios.close();
    }

    private static void saveImageAs(String formatName, BufferedImage img, Object out) throws IOException {
        boolean found = false;
        if (out instanceof File) {
            found = ImageIO.write((RenderedImage)img, formatName, (File)out);
        } else if (out instanceof ImageOutputStream) {
            found = ImageIO.write((RenderedImage)img, formatName, (ImageOutputStream)out);
        } else if (out instanceof OutputStream) {
            found = ImageIO.write((RenderedImage)img, formatName, (OutputStream)out);
        } else assert (false) : "\u4e0d\u6b63\u306a\u66f8\u304d\u8fbc\u307f\u5bfe\u8c61\u30aa\u30d6\u30b8\u30a7\u30af\u30c8";
        assert (found) : formatName.toUpperCase() + " writer was not found.";
    }

    public void assign(ScreenShotOption source) {
        this.scale = source.scale;
        this.format = source.format;
        this.compress = source.compress;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Format {
        JPG{

            public String getExt() {
                return "jpg";
            }

            public String getDisplayName() {
                return "JPEG";
            }
        }
        ,
        PNG{

            public String getExt() {
                return "png";
            }

            public String getDisplayName() {
                return "PNG";
            }
        }
        ,
        BMP{

            public String getExt() {
                return "bmp";
            }

            public String getDisplayName() {
                return "BMP";
            }
        }
        ,
        GIF{

            public String getExt() {
                return "gif";
            }

            public String getDisplayName() {
                return "GIF";
            }
        };


        public abstract String getExt();

        public abstract String getDisplayName();

        public static Format parseFormat(String s) {
            Format[] formats;
            s = s.toLowerCase();
            for (Format f : formats = Format.values()) {
                if (!s.equals(f.getExt())) continue;
                return f;
            }
            if (s.equals("jpeg")) {
                return JPG;
            }
            return null;
        }
    }
}

