/*
 * Decompiled with CFR 0.152.
 */
package komadoriki.logger;

import com.kazina.j.KzUtils;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Arrays;
import java.util.regex.Matcher;
import komadoriki.logger.BenriDate;
import komadoriki.logger.ScreenShotLogger;

public final class SnapShotLogDrawer {
    private OneSnapShot[] snapShots;
    private final String logPath;

    public SnapShotLogDrawer(String logDirectory) {
        this.logPath = KzUtils.includingPathDelimiter(logDirectory);
    }

    private void setSnapShots(File[] files) {
        int i;
        OneSnapShot[] tempList = new OneSnapShot[files.length];
        int p = 0;
        int ls = -1;
        for (int i2 = 0; i2 < files.length; ++i2) {
            int s;
            int m;
            int h;
            int sec;
            String fileName = files[i2].getName();
            Matcher mt = ScreenShotLogger.PATTERN_SNAPSHOT_FILENAME.matcher(fileName);
            if (!mt.matches() || (sec = BenriDate.getSecondOfDay(h = Integer.parseInt(mt.group(1)), m = Integer.parseInt(mt.group(2)), s = Integer.parseInt(mt.group(3)))) == ls) continue;
            tempList[p++] = new OneSnapShot(sec, files[i2]);
            ls = sec;
        }
        int count = 0;
        for (i = 0; i < tempList.length; ++i) {
            if (tempList[i] == null) continue;
            ++count;
        }
        this.snapShots = new OneSnapShot[count];
        p = 0;
        for (i = 0; i < tempList.length; ++i) {
            if (tempList[i] == null) continue;
            this.snapShots[p++] = tempList[i];
        }
        tempList = null;
        Arrays.sort(this.snapShots);
    }

    public void load(BenriDate date) {
        this.clear();
        File dayDirectory = new File(this.logPath + ScreenShotLogger.getDateDirectoryName(date));
        if (!dayDirectory.exists()) {
            return;
        }
        File[] files = dayDirectory.listFiles(new FilenameFilter(){

            public boolean accept(File f, String fileName) {
                boolean result = f.isDirectory();
                if (result) {
                    Matcher mt = ScreenShotLogger.PATTERN_SNAPSHOT_FILENAME.matcher(fileName);
                    result = mt.matches();
                }
                return result;
            }
        });
        this.setSnapShots(files);
    }

    public void clear() {
        this.snapShots = null;
        System.gc();
    }

    public int getFirstSecond() {
        if (this.hasSnapshot()) {
            return this.snapShots[0].secondOfDay;
        }
        return -1;
    }

    public int getLastSecond() {
        if (this.hasSnapshot()) {
            return this.snapShots[this.snapShots.length - 1].secondOfDay;
        }
        return -1;
    }

    private boolean hasSnapshot() {
        return this.snapShots != null && this.snapShots.length >= 1;
    }

    public int getCount() {
        if (this.hasSnapshot()) {
            return this.snapShots.length;
        }
        return 0;
    }

    public OneSnapShot getSnapshot(int index) {
        return this.snapShots[index];
    }

    public OneSnapShot getSnapshotByTime(int time) {
        OneSnapShot result = null;
        int d = 8640000;
        for (int i = 0; i < this.getCount(); ++i) {
            int abs = Math.abs(this.snapShots[i].secondOfDay - time);
            if (abs >= d) continue;
            result = this.snapShots[i];
            d = abs;
        }
        return result;
    }

    public final class OneSnapShot
    implements Comparable {
        public int secondOfDay;
        public File file;

        private OneSnapShot(int i, File f) {
            this.secondOfDay = i;
            this.file = f;
        }

        public int compareTo(Object obj) {
            if (obj == null) {
                return 1;
            }
            if (!(obj instanceof OneSnapShot)) {
                throw new ClassCastException();
            }
            return this.secondOfDay - ((OneSnapShot)obj).secondOfDay;
        }
    }
}

