/*
 * Decompiled with CFR 0.152.
 */
package komadoriki.main;

import com.kazina.j.KzUtils;
import java.awt.AWTException;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import komadoriki.logger.ScreenShotLogger;
import komadoriki.logger.ScreenShotOption;
import komadoriki.main.ImagePanel;

public class ConfigDialog2
extends JDialog {
    private boolean okSelected = false;
    private boolean updatingOption = false;
    private final ScreenShotOption currentOption = new ScreenShotOption();
    private BufferedImage compressedScreenShot;
    private JButton btnCancel;
    private JButton btnOk;
    private ButtonGroup buttonGroup1;
    private JPanel grpPreview;
    private ImagePanel imagePanel1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JScrollPane jScrollPane1;
    private JSlider jSlider1;
    private JLabel lblFileSize;
    private JLabel lblResize;
    private JPanel pnlBmp;
    private JPanel pnlFormatOption;
    private JPanel pnlGif;
    private JPanel pnlJpeg;
    private JPanel pnlPng;
    private JRadioButton rdoBmp;
    private JRadioButton rdoGif;
    private JRadioButton rdoJpeg;
    private JRadioButton rdoPng;
    private JSlider sldResize;

    private ConfigDialog2(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        KzUtils.disposeWhenESC(this);
    }

    public static final boolean execute(Frame parent, ScreenShotLogger target) {
        ConfigDialog2 dlg = new ConfigDialog2(parent, true);
        dlg.setProperty(target);
        dlg.setLocationRelativeTo(parent);
        dlg.setVisible(true);
        if (dlg.okSelected) {
            target.option.assign(dlg.currentOption);
        }
        return dlg.okSelected;
    }

    private void setProperty(ScreenShotLogger target) {
        this.currentOption.assign(target.option);
        this.updatingOption = true;
        switch (this.currentOption.format) {
            case JPG: {
                this.rdoJpeg.setSelected(true);
                break;
            }
            case PNG: {
                this.rdoPng.setSelected(true);
                break;
            }
            case BMP: {
                this.rdoBmp.setSelected(true);
                break;
            }
            case GIF: {
                this.rdoGif.setSelected(true);
            }
        }
        this.showOptionPanel(this.currentOption.format);
        this.jSlider1.setValue(this.currentOption.getCompress());
        this.sldResize.setValue((int)(this.currentOption.getScale() * 100.0f));
        this.updatingOption = false;
        this.updatePreview();
    }

    private final void showOptionPanel(ScreenShotOption.Format f) {
        assert (this.pnlFormatOption.getLayout() instanceof CardLayout) : "\u30d5\u30a9\u30fc\u30de\u30c3\u30c8\u30aa\u30d7\u30b7\u30e7\u30f3\u7528\u30d1\u30cd\u30eb\u304c\u30ab\u30fc\u30c9\u30ec\u30a4\u30a2\u30a6\u30c8\u3067\u306f\u306a\u3044";
        CardLayout card = (CardLayout)this.pnlFormatOption.getLayout();
        card.show(this.pnlFormatOption, f.getExt());
    }

    private int updateImage() {
        BufferedImage screenShot = null;
        try {
            screenShot = new Robot().createScreenCapture(new Rectangle(Toolkit.getDefaultToolkit().getScreenSize()));
        }
        catch (HeadlessException e) {
            e.printStackTrace();
        }
        catch (AWTException e) {
            e.printStackTrace();
        }
        int result = -1;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            this.currentOption.saveImage(screenShot, out);
            ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
            if (this.compressedScreenShot != null) {
                this.compressedScreenShot.flush();
            }
            this.compressedScreenShot = ImageIO.read(in);
            result = out.size();
            out.close();
            out = null;
            in.close();
            in = null;
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        return result;
    }

    private void updatePreview() {
        if (this.updatingOption) {
            return;
        }
        int fileSize = this.updateImage();
        Dimension d = new Dimension(this.compressedScreenShot.getWidth(), this.compressedScreenShot.getHeight());
        this.imagePanel1.setSize(this.compressedScreenShot.getWidth(), this.compressedScreenShot.getHeight());
        this.imagePanel1.setMinimumSize(d);
        this.imagePanel1.setPreferredSize(d);
        this.imagePanel1.image = this.compressedScreenShot;
        this.imagePanel1.repaint();
        String s = "\u30d5\u30a9\u30fc\u30de\u30c3\u30c8: " + this.currentOption.format.getDisplayName() + "\u5f62\u5f0f";
        if (this.currentOption.format == ScreenShotOption.Format.JPG) {
            s = s + " \u753b\u8cea: " + this.currentOption.getCompress();
        }
        s = s + " / \u30d5\u30a1\u30a4\u30eb\u30b5\u30a4\u30ba: " + KzUtils.smartByteSize(fileSize);
        this.lblFileSize.setText(s);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int sw = (int)((float)screenSize.width * ((float)this.sldResize.getValue() / 100.0f));
        int sh = (int)((float)screenSize.height * ((float)this.sldResize.getValue() / 100.0f));
        this.lblResize.setText("\u7e2e\u5c0f\u5f8c\u306e\u30b5\u30a4\u30ba: " + sw + " x " + sh);
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.grpPreview = new JPanel();
        this.lblFileSize = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.imagePanel1 = new ImagePanel();
        this.jPanel2 = new JPanel();
        this.btnOk = new JButton();
        this.btnCancel = new JButton();
        this.jPanel3 = new JPanel();
        this.rdoJpeg = new JRadioButton();
        this.rdoPng = new JRadioButton();
        this.rdoGif = new JRadioButton();
        this.rdoBmp = new JRadioButton();
        this.pnlFormatOption = new JPanel();
        this.pnlJpeg = new JPanel();
        this.jSlider1 = new JSlider();
        this.jLabel1 = new JLabel();
        this.pnlPng = new JPanel();
        this.jLabel2 = new JLabel();
        this.pnlBmp = new JPanel();
        this.jLabel3 = new JLabel();
        this.pnlGif = new JPanel();
        this.jLabel4 = new JLabel();
        this.jPanel1 = new JPanel();
        this.sldResize = new JSlider();
        this.lblResize = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle("\u8a2d\u5b9a");
        this.setMinimumSize(new Dimension(600, 400));
        this.setModal(true);
        this.grpPreview.setBorder(BorderFactory.createTitledBorder("\u30d7\u30ec\u30d3\u30e5\u30fc"));
        this.lblFileSize.setText("jLabel1");
        GroupLayout imagePanel1Layout = new GroupLayout(this.imagePanel1);
        this.imagePanel1.setLayout(imagePanel1Layout);
        imagePanel1Layout.setHorizontalGroup(imagePanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 638, Short.MAX_VALUE));
        imagePanel1Layout.setVerticalGroup(imagePanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 375, Short.MAX_VALUE));
        this.jScrollPane1.setViewportView(this.imagePanel1);
        GroupLayout grpPreviewLayout = new GroupLayout(this.grpPreview);
        this.grpPreview.setLayout(grpPreviewLayout);
        grpPreviewLayout.setHorizontalGroup(grpPreviewLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(grpPreviewLayout.createSequentialGroup().addContainerGap().addGroup(grpPreviewLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 640, Short.MAX_VALUE).addComponent(this.lblFileSize)).addContainerGap()));
        grpPreviewLayout.setVerticalGroup(grpPreviewLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(grpPreviewLayout.createSequentialGroup().addComponent(this.lblFileSize).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 377, Short.MAX_VALUE).addContainerGap()));
        this.jPanel2.setMinimumSize(new Dimension(256, 32));
        this.jPanel2.setPreferredSize(new Dimension(256, 32));
        this.jPanel2.setLayout(new GridLayout(1, 0, 8, 0));
        this.btnOk.setText("OK");
        this.btnOk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ConfigDialog2.this.btnOkActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.btnOk);
        this.btnCancel.setText("\u30ad\u30e3\u30f3\u30bb\u30eb");
        this.btnCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ConfigDialog2.this.btnCancelActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.btnCancel);
        this.jPanel3.setBorder(BorderFactory.createTitledBorder("\u4fdd\u5b58\u5f62\u5f0f"));
        this.buttonGroup1.add(this.rdoJpeg);
        this.rdoJpeg.setMnemonic('J');
        this.rdoJpeg.setText("JPEG");
        this.rdoJpeg.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ConfigDialog2.this.rdoJpegActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.rdoPng);
        this.rdoPng.setMnemonic('P');
        this.rdoPng.setText("PNG");
        this.rdoPng.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ConfigDialog2.this.rdoJpegActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.rdoGif);
        this.rdoGif.setMnemonic('G');
        this.rdoGif.setText("GIF");
        this.rdoGif.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ConfigDialog2.this.rdoJpegActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.rdoBmp);
        this.rdoBmp.setMnemonic('B');
        this.rdoBmp.setText("BMP");
        this.rdoBmp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ConfigDialog2.this.rdoJpegActionPerformed(evt);
            }
        });
        this.pnlFormatOption.setLayout(new CardLayout());
        this.jSlider1.setMajorTickSpacing(10);
        this.jSlider1.setMinimum(20);
        this.jSlider1.setMinorTickSpacing(5);
        this.jSlider1.setPaintLabels(true);
        this.jSlider1.setPaintTicks(true);
        this.jSlider1.setSnapToTicks(true);
        this.jSlider1.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                ConfigDialog2.this.jSlider1StateChanged(evt);
            }
        });
        this.jLabel1.setText("\u54c1\u8cea");
        GroupLayout pnlJpegLayout = new GroupLayout(this.pnlJpeg);
        this.pnlJpeg.setLayout(pnlJpegLayout);
        pnlJpegLayout.setHorizontalGroup(pnlJpegLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlJpegLayout.createSequentialGroup().addContainerGap().addGroup(pnlJpegLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSlider1, -1, 353, Short.MAX_VALUE).addComponent(this.jLabel1)).addContainerGap()));
        pnlJpegLayout.setVerticalGroup(pnlJpegLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlJpegLayout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSlider1, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.pnlFormatOption.add((Component)this.pnlJpeg, "jpg");
        this.jLabel2.setText("PNG\u5f62\u5f0f\u306b\u8a2d\u5b9a\u53ef\u80fd\u306a\u30aa\u30d7\u30b7\u30e7\u30f3\u306f\u3042\u308a\u307e\u305b\u3093\u3002");
        GroupLayout pnlPngLayout = new GroupLayout(this.pnlPng);
        this.pnlPng.setLayout(pnlPngLayout);
        pnlPngLayout.setHorizontalGroup(pnlPngLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlPngLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabel2).addContainerGap(142, Short.MAX_VALUE)));
        pnlPngLayout.setVerticalGroup(pnlPngLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlPngLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabel2).addContainerGap(50, Short.MAX_VALUE)));
        this.pnlFormatOption.add((Component)this.pnlPng, "png");
        this.jLabel3.setText("BMP\u5f62\u5f0f\u306b\u8a2d\u5b9a\u53ef\u80fd\u306a\u30aa\u30d7\u30b7\u30e7\u30f3\u306f\u3042\u308a\u307e\u305b\u3093\u3002");
        GroupLayout pnlBmpLayout = new GroupLayout(this.pnlBmp);
        this.pnlBmp.setLayout(pnlBmpLayout);
        pnlBmpLayout.setHorizontalGroup(pnlBmpLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlBmpLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabel3).addContainerGap(141, Short.MAX_VALUE)));
        pnlBmpLayout.setVerticalGroup(pnlBmpLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlBmpLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabel3).addContainerGap(50, Short.MAX_VALUE)));
        this.pnlFormatOption.add((Component)this.pnlBmp, "bmp");
        this.jLabel4.setText("GIF\u5f62\u5f0f\u306b\u8a2d\u5b9a\u53ef\u80fd\u306a\u30aa\u30d7\u30b7\u30e7\u30f3\u306f\u3042\u308a\u307e\u305b\u3093\u3002");
        GroupLayout pnlGifLayout = new GroupLayout(this.pnlGif);
        this.pnlGif.setLayout(pnlGifLayout);
        pnlGifLayout.setHorizontalGroup(pnlGifLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlGifLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabel4).addContainerGap(147, Short.MAX_VALUE)));
        pnlGifLayout.setVerticalGroup(pnlGifLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlGifLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabel4).addContainerGap(50, Short.MAX_VALUE)));
        this.pnlFormatOption.add((Component)this.pnlGif, "gif");
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pnlFormatOption, -1, 377, Short.MAX_VALUE).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.rdoJpeg).addGap(18, 18, 18).addComponent(this.rdoPng).addGap(18, 18, 18).addComponent(this.rdoGif).addGap(18, 18, 18).addComponent(this.rdoBmp))).addContainerGap()));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.rdoJpeg).addComponent(this.rdoPng).addComponent(this.rdoGif).addComponent(this.rdoBmp)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.pnlFormatOption, -1, 73, Short.MAX_VALUE).addContainerGap()));
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("\u7e2e\u5c0f"));
        this.sldResize.setMajorTickSpacing(10);
        this.sldResize.setMinimum(20);
        this.sldResize.setPaintLabels(true);
        this.sldResize.setPaintTicks(true);
        this.sldResize.setValue(80);
        this.sldResize.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                ConfigDialog2.this.sldResizeStateChanged(evt);
            }
        });
        this.lblResize.setText("jLabel5");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblResize).addComponent(this.sldResize, GroupLayout.Alignment.TRAILING, -1, 220, Short.MAX_VALUE)).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.lblResize).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sldResize, -2, -1, -2)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.grpPreview, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel2, -2, -1, -2)))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.grpPreview, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -2, -1, -2)).addComponent(this.jPanel3, -2, 137, -2)).addContainerGap()));
        this.getAccessibleContext().setAccessibleName(null);
        this.pack();
    }

    private void btnOkActionPerformed(ActionEvent evt) {
        this.okSelected = true;
        this.dispose();
    }

    private void btnCancelActionPerformed(ActionEvent evt) {
        this.okSelected = false;
        this.dispose();
    }

    private void jSlider1StateChanged(ChangeEvent evt) {
        if (!this.jSlider1.getValueIsAdjusting()) {
            this.currentOption.setCompress(this.jSlider1.getValue());
            this.updatePreview();
        }
    }

    private void rdoJpegActionPerformed(ActionEvent evt) {
        this.currentOption.format = ScreenShotOption.Format.parseFormat(evt.getActionCommand());
        this.showOptionPanel(this.currentOption.format);
        this.updatePreview();
    }

    private void sldResizeStateChanged(ChangeEvent evt) {
        if (!this.sldResize.getValueIsAdjusting()) {
            this.currentOption.setScale((float)this.sldResize.getValue() / 100.0f);
            this.updatePreview();
        }
    }
}

