/*
 * Decompiled with CFR 0.152.
 */
package komadoriki.main;

import java.awt.Graphics;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.HashSet;
import javax.swing.JComponent;

public final class DaySlider
extends JComponent
implements MouseListener {
    private static final int ARROW_SIZE = 5;
    private int nowTime = 0;
    private int startTime = 0;
    private int endTime = 86399;
    private HashSet<Integer> tickPoints = new HashSet();
    private ActionListener listener = null;

    public DaySlider() {
        this.addMouseListener(this);
    }

    public void paint(Graphics g) {
        int i;
        g.setColor(SystemColor.control);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        int lineY = 5;
        g.setColor(SystemColor.controlText);
        g.drawLine(0, 5, this.getWidth(), 5);
        if (this.endTime - this.startTime > 0) {
            int nx = (this.nowTime - this.startTime) * (this.getWidth() - 1) / (this.endTime - this.startTime);
            for (i = 0; i <= 5; ++i) {
                g.drawLine(nx - i, 5 - i - 1, nx + i, 5 - i - 1);
            }
        }
        int ascent = g.getFontMetrics().getAscent();
        for (i = 0; i < 24; ++i) {
            if (this.startTime > i * 60 * 60 || i * 60 * 60 > this.endTime) continue;
            int x = (i * 60 * 60 - this.startTime) * (this.getWidth() - 1) / (this.endTime - this.startTime);
            g.drawLine(x, 5, x, 13);
            String s = i + ":00";
            int sw = g.getFontMetrics().stringWidth(s);
            int sx = x - sw / 2;
            if (sx < 0) {
                sx = 0;
            }
            g.drawString(s, sx, 14 + ascent);
        }
        for (Integer i2 : this.tickPoints) {
            if (this.startTime > i2 || i2 > this.endTime) continue;
            int x = (i2 - this.startTime) * (this.getWidth() - 1) / (this.endTime - this.startTime);
            g.drawLine(x, 5, x, 9);
        }
    }

    public void update(Graphics arg0) {
        this.paint(arg0);
    }

    public void setStartTime(int value) {
        this.startTime = value;
        if (this.startTime > this.endTime) {
            this.endTime = this.startTime;
        }
        if (this.nowTime < this.startTime) {
            this.nowTime = this.startTime;
        }
        this.repaint();
    }

    public void setEndTime(int value) {
        this.endTime = value;
        if (this.startTime > this.endTime) {
            this.startTime = this.endTime;
        }
        if (this.nowTime > this.endTime) {
            this.nowTime = this.endTime;
        }
        this.repaint();
    }

    public int getEndTime() {
        return this.endTime;
    }

    public void setTime(int value) {
        this.nowTime = value;
        if (this.nowTime < this.startTime) {
            this.nowTime = this.startTime;
        }
        if (this.nowTime > this.endTime) {
            this.nowTime = this.endTime;
        }
        this.nowTime = this.getNearestTime(this.nowTime);
        this.repaint();
        if (this.listener != null) {
            ActionEvent ae = new ActionEvent(this, 0, null);
            this.listener.actionPerformed(ae);
        }
    }

    public int getTime() {
        return this.nowTime;
    }

    public void addTickPoint(int value) {
        if (0 <= value && value < 86400) {
            this.tickPoints.add(value);
        }
    }

    public void clearTicks() {
        this.tickPoints.clear();
    }

    public void setActionListener(ActionListener al) {
        this.listener = al;
    }

    public void mouseClicked(MouseEvent e) {
        int x = e.getPoint().x;
        int v = x * (this.endTime - this.startTime) / this.getWidth();
        v = this.getNearestTime(this.startTime + v);
        this.setTime(v);
    }

    public void mousePressed(MouseEvent arg0) {
    }

    public void mouseReleased(MouseEvent arg0) {
    }

    public void mouseEntered(MouseEvent arg0) {
    }

    public void mouseExited(MouseEvent arg0) {
    }

    private int getNearestTime(int value) {
        if (this.tickPoints.contains(value)) {
            return value;
        }
        int d = 86400;
        int result = -1;
        for (int t : this.tickPoints) {
            if (Math.abs(value - t) >= d) continue;
            d = Math.abs(value - t);
            result = t;
        }
        return result;
    }

    public boolean nextTime() {
        return this.next(false);
    }

    public boolean prevTime() {
        return this.next(true);
    }

    private boolean next(boolean prev) {
        boolean result;
        int d = 86400;
        int nextTime = -1;
        for (int t : this.tickPoints) {
            int def = prev ? this.nowTime - t : t - this.nowTime;
            if (def <= 0 || def >= d) continue;
            nextTime = t;
            d = def;
        }
        boolean bl = result = nextTime != -1;
        if (result) {
            this.setTime(nextTime);
        }
        return result;
    }
}

