/*
 * Decompiled with CFR 0.152.
 */
package komadoriki.main;

import com.kazina.j.KzUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.Timer;
import komadoriki.logger.BenriDate;
import komadoriki.logger.SnapShotLogDrawer;
import komadoriki.main.DaySlider;
import komadoriki.main.ImagePanel;
import komadoriki.main.Komadoriki;
import komadoriki.main.MainWindow2;

public class LogViewDialog
extends JDialog
implements ActionListener {
    private static final String BUTTON_CAPTION_PLAY = "\u518d\u751f(P)";
    private static final int TIMER_INTERVAL = 0;
    private Timer timPlay;
    private SnapShotLogDrawer logSnapShot;
    private BenriDate[] selectableDates;
    private BufferedImage currentImage;
    private DefaultComboBoxModel comboModel;
    private JButton btnNextSnap;
    private JButton btnPlay;
    private JButton btnPrevSnap;
    private JComboBox cmbDates;
    private ImagePanel imagePanel1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JLabel lblDateInfo;
    private DaySlider sldTime;

    public LogViewDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.setLocationRelativeTo(parent);
        KzUtils.disposeWhenESC(this);
        this.logSnapShot = new SnapShotLogDrawer(MainWindow2.logDirectory.getAbsolutePath());
        this.sldTime.setActionListener(this);
        File[] dayDirectories = MainWindow2.logDirectory.listFiles(new FilenameFilter(){

            public boolean accept(File f, String fileName) {
                return f.isDirectory() && fileName.matches("(\\d{4})-(\\d{2})-(\\d{2})");
            }
        });
        this.comboModel = new DefaultComboBoxModel();
        this.selectableDates = new BenriDate[dayDirectories.length];
        for (int i = 0; i < dayDirectories.length; ++i) {
            this.selectableDates[i] = new BenriDate();
            this.selectableDates[i].decode(dayDirectories[i].getName());
            this.comboModel.addElement(this.selectableDates[i]);
        }
        this.cmbDates.setModel(this.comboModel);
        this.timPlay = new Timer(0, this);
        this.timPlay.setDelay(0);
        this.cmbDates.setSelectedIndex(this.cmbDates.getItemCount() - 1);
        this.sldTime.setTime(new BenriDate().getSecondOfDay());
    }

    public int getDateCount() {
        return this.comboModel.getSize();
    }

    private void updateTitle(boolean updateSnapShot) {
        if (this.selectableDates.length > 0) {
            BenriDate date = new BenriDate();
            date.setTime(this.sldTime.getTime());
            this.setTitle(Komadoriki.appli.appName() + " - " + this.selectableDates[this.cmbDates.getSelectedIndex()].format("yyyy\u5e74MM\u6708dd\u65e5 ") + date.format("HH:mm:ss"));
            if (updateSnapShot) {
                this.imagePanel1.repaint();
            }
        }
    }

    private void stopPlay() {
        this.timPlay.stop();
        this.btnPlay.setText(BUTTON_CAPTION_PLAY);
    }

    private void prepareDay(BenriDate date) {
        this.logSnapShot.load(date);
        this.lblDateInfo.setText(this.logSnapShot.getCount() + "\u679a\u306e\u30b9\u30af\u30ea\u30fc\u30f3\u30b7\u30e7\u30c3\u30c8\u304c\u898b\u3064\u304b\u308a\u307e\u3057\u305f\u3002");
        this.sldTime.clearTicks();
        for (int i = 0; i < this.logSnapShot.getCount(); ++i) {
            this.sldTime.addTickPoint(this.logSnapShot.getSnapshot((int)i).secondOfDay);
        }
        this.sldTime.setStartTime(this.logSnapShot.getFirstSecond());
        this.sldTime.setEndTime(this.logSnapShot.getLastSecond());
        this.sldTime.setTime(this.sldTime.getTime());
    }

    public void actionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.sldTime) {
            this.updateTitle(false);
            if (this.currentImage != null) {
                this.currentImage.flush();
            }
            if (this.selectableDates.length > 0) {
                File f = this.logSnapShot.getSnapshotByTime((int)this.sldTime.getTime()).file;
                try {
                    this.currentImage = ImageIO.read(f);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                this.imagePanel1.image = this.currentImage;
                this.imagePanel1.repaint();
                Dimension d = new Dimension(this.currentImage.getWidth(), this.currentImage.getHeight());
                this.imagePanel1.setSize(d);
                this.imagePanel1.setMinimumSize(d);
                this.imagePanel1.setMaximumSize(d);
                this.imagePanel1.setPreferredSize(d);
            }
        } else if (ae.getSource() == this.timPlay && !this.sldTime.nextTime()) {
            this.stopPlay();
        }
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.imagePanel1 = new ImagePanel();
        this.jPanel2 = new JPanel();
        this.btnPrevSnap = new JButton();
        this.btnPlay = new JButton();
        this.cmbDates = new JComboBox();
        this.btnNextSnap = new JButton();
        this.lblDateInfo = new JLabel();
        this.sldTime = new DaySlider();
        this.setDefaultCloseOperation(2);
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("\u30b9\u30af\u30ea\u30fc\u30f3\u30b7\u30e7\u30c3\u30c8"));
        GroupLayout imagePanel1Layout = new GroupLayout(this.imagePanel1);
        this.imagePanel1.setLayout(imagePanel1Layout);
        imagePanel1Layout.setHorizontalGroup(imagePanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 666, Short.MAX_VALUE));
        imagePanel1Layout.setVerticalGroup(imagePanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 357, Short.MAX_VALUE));
        this.jScrollPane1.setViewportView(this.imagePanel1);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 668, Short.MAX_VALUE).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 359, Short.MAX_VALUE).addContainerGap()));
        this.jPanel2.setLayout(new GridBagLayout());
        this.btnPrevSnap.setText("<");
        this.btnPrevSnap.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LogViewDialog.this.btnPrevSnapActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel2.add((Component)this.btnPrevSnap, gridBagConstraints);
        this.btnPlay.setMnemonic('P');
        this.btnPlay.setText(BUTTON_CAPTION_PLAY);
        this.btnPlay.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LogViewDialog.this.btnPlayActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel2.add((Component)this.btnPlay, gridBagConstraints);
        this.cmbDates.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.cmbDates.setMaximumSize(new Dimension(Short.MAX_VALUE, 21));
        this.cmbDates.setMinimumSize(new Dimension(51, 21));
        this.cmbDates.setPreferredSize(new Dimension(56, 21));
        this.cmbDates.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LogViewDialog.this.cmbDatesActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel2.add((Component)this.cmbDates, gridBagConstraints);
        this.btnNextSnap.setText(">");
        this.btnNextSnap.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LogViewDialog.this.btnNextSnapActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel2.add((Component)this.btnNextSnap, gridBagConstraints);
        this.lblDateInfo.setText("jLabel1");
        GroupLayout sldTimeLayout = new GroupLayout(this.sldTime);
        this.sldTime.setLayout(sldTimeLayout);
        sldTimeLayout.setHorizontalGroup(sldTimeLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 536, Short.MAX_VALUE));
        sldTimeLayout.setVerticalGroup(sldTimeLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 35, Short.MAX_VALUE));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(12, 12, 12).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jPanel1, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jPanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.sldTime, -1, -1, Short.MAX_VALUE).addComponent(this.lblDateInfo, -1, 536, Short.MAX_VALUE)))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(13, 13, 13).addComponent(this.lblDateInfo).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sldTime, -2, -1, -2)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -2, -1, -2))).addContainerGap()));
        this.pack();
    }

    private void btnPrevSnapActionPerformed(ActionEvent evt) {
        this.sldTime.prevTime();
    }

    private void btnNextSnapActionPerformed(ActionEvent evt) {
        this.sldTime.nextTime();
    }

    private void btnPlayActionPerformed(ActionEvent evt) {
        if (this.timPlay.isRunning()) {
            this.stopPlay();
        } else {
            this.timPlay.start();
            this.btnPlay.setText("\u505c\u6b62(P)");
        }
    }

    private void cmbDatesActionPerformed(ActionEvent evt) {
        this.stopPlay();
        if (this.comboModel.getSelectedItem() != null) {
            this.prepareDay((BenriDate)this.comboModel.getSelectedItem());
            this.updateTitle(true);
        }
    }
}

