/*
 * Decompiled with CFR 0.152.
 */
package komadoriki.main;

import com.kazina.j.KzImageSelection;
import com.kazina.j.KzIniFile;
import com.kazina.j.KzUtils;
import java.awt.AWTException;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowStateListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import komadoriki.logger.BenriDate;
import komadoriki.logger.ScreenShotLogger;
import komadoriki.logger.ScreenShotOption;
import komadoriki.main.ConfigDialog2;
import komadoriki.main.Komadoriki;
import komadoriki.main.LogViewDialog;

public class MainWindow2
extends JFrame {
    private static final String MSG_NO_LOG = "\u30b9\u30af\u30ea\u30fc\u30f3\u30b7\u30e7\u30c3\u30c8\u306e\u30ed\u30b0\u304c\u3042\u308a\u307e\u305b\u3093\u3002";
    private static final String PROP_ACTIVE = "active";
    private static final String PROP_SNAPSHOT = "interval";
    private static final String PROP_SNAPSHOT_COMPRESS = "snapshot_compress";
    private static final String PROP_SS_FORMAT = "screenshot.format";
    private static final String PROP_SS_SCALE = "screenshot.scale";
    private static final int[] INTERVALS = new int[]{10, 30, 60, 120, 180, 300, 600, 900, 1200, 1800, 3600};
    private static final String[] INTERVAL_LABELS = new String[]{"10\u79d2", "30\u79d2", "1\u5206", "2\u5206", "3\u5206", "5\u5206", "10\u5206", "15\u5206", "20\u5206", "30\u5206", "1\u6642\u9593"};
    private static final String[] INTERVAL_ICON_FILENAMES = new String[]{"10sec", "30sec", "1min", "2min", "3min", "5min", "10min", "15min", "20min", "30min", "60min"};
    private static final BufferedImage[] INTERVAL_ICON_IMAGES = new BufferedImage[INTERVALS.length];
    public static File logDirectory = new File(Komadoriki.appli.getApplicationDirectory().getAbsolutePath() + File.separator + "snapshot");
    public ScreenShotLogger snapLogger;
    private final TrayIcon trayIcon;
    private final BufferedImage trayIconImage;
    private JButton btnConfig;
    private JButton btnLog;
    private JButton btnStart;
    private JButton btnStop;
    private JMenu jMenu2;
    private JMenuBar jMenuBar1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JSlider jSlider1;
    private JLabel lblCount;
    private JMenuItem mnuAbout;
    private JMenuItem mnuExit;
    private JMenuItem mnuKazinaCom;
    private JMenuItem mnuScreenShotDirectory;
    private MenuItem popCaptureNow;
    private MenuItem popConfig;
    private MenuItem popCopyScreenShot;
    private MenuItem popExit;
    private MenuItem popLog;
    private MenuItem popScreenShotDirectory;
    private MenuItem popStart;
    private MenuItem popStop;
    private PopupMenu popTrayIcon;

    public MainWindow2() {
        this.initComponents();
        this.setTitle(Komadoriki.appli.appName());
        String RC_PATH = "/komadoriki/main/images/";
        ArrayList<BufferedImage> icons = new ArrayList<BufferedImage>();
        try {
            icons.add(ImageIO.read(this.getClass().getResource("/komadoriki/main/images/icon016.png")));
            icons.add(ImageIO.read(this.getClass().getResource("/komadoriki/main/images/icon032.png")));
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        this.setIconImages(icons);
        Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
        for (int i = 0; i < INTERVAL_LABELS.length; ++i) {
            ((Dictionary)labelTable).put(i, new JLabel(INTERVAL_LABELS[i]));
        }
        this.jSlider1.setMinimum(0);
        this.jSlider1.setMaximum(INTERVAL_LABELS.length - 1);
        this.jSlider1.setLabelTable(labelTable);
        if (SystemTray.isSupported()) {
            BufferedImage img = null;
            try {
                img = ImageIO.read(this.getClass().getResource("/komadoriki/main/images/stop.gif"));
                for (int i = 0; i < INTERVALS.length; ++i) {
                    MainWindow2.INTERVAL_ICON_IMAGES[i] = ImageIO.read(this.getClass().getResource("/komadoriki/main/images/" + INTERVAL_ICON_FILENAMES[i] + ".gif"));
                }
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            TrayIcon icon = new TrayIcon(img, Komadoriki.appli.appName(), this.popTrayIcon);
            icon.setImageAutoSize(true);
            icon.addMouseListener(new MouseListener(){

                public void mouseClicked(MouseEvent e) {
                    if (e.getButton() == 1 && e.getClickCount() == 1 && !MainWindow2.this.isVisible()) {
                        MainWindow2.this.setVisible(true);
                        MainWindow2.this.toFront();
                    }
                }

                public void mouseEntered(MouseEvent e) {
                }

                public void mouseExited(MouseEvent e) {
                }

                public void mousePressed(MouseEvent e) {
                }

                public void mouseReleased(MouseEvent e) {
                }
            });
            SystemTray tray = SystemTray.getSystemTray();
            try {
                tray.add(icon);
            }
            catch (AWTException e) {
                e.printStackTrace();
                icon = null;
            }
            this.trayIcon = icon;
            this.trayIconImage = img;
        } else {
            this.trayIcon = null;
            this.trayIconImage = null;
        }
    }

    public boolean ready() throws FileNotFoundException, IOException {
        if (!logDirectory.exists() && !logDirectory.mkdirs()) {
            throw new IOException("\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u304c\u4f5c\u6210\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002\n" + logDirectory);
        }
        this.snapLogger = new ScreenShotLogger(logDirectory.getCanonicalPath());
        return this.configLoad();
    }

    private boolean configLoad() throws FileNotFoundException, IOException {
        int snapInterval;
        boolean active;
        int y;
        int x;
        KzIniFile ini = new KzIniFile(Komadoriki.appli.getApplicationConfigFileName());
        if (ini.keyExists("version")) {
            x = ini.readInt("window.x", 32);
            y = ini.readInt("window.y", 32);
            active = ini.readBool(PROP_ACTIVE, false);
            snapInterval = ini.readInt(PROP_SNAPSHOT, 300);
            this.snapLogger.option.format = ScreenShotOption.Format.parseFormat(ini.readString(PROP_SS_FORMAT, "jpg"));
            this.snapLogger.option.setCompress(ini.readInt(PROP_SNAPSHOT_COMPRESS, 80));
            this.snapLogger.option.setScale(ini.readFloat(PROP_SS_SCALE, 0.8f));
        } else {
            y = 32;
            x = 32;
            active = ini.readBool(PROP_ACTIVE, false);
            snapInterval = ini.readInt(PROP_SNAPSHOT, 300);
            this.snapLogger.option.setCompress(ini.readInt(PROP_SNAPSHOT_COMPRESS, this.snapLogger.option.getCompress()));
        }
        this.setLocation(x, y);
        MainWindow2.setSliderValue(this.jSlider1, snapInterval);
        return active;
    }

    private void configSave() throws IOException {
        KzIniFile ini = new KzIniFile(Komadoriki.appli.getApplicationConfigFileName());
        ini.writeInt("version", 1);
        ini.writeInt("window.x", this.getX());
        ini.writeInt("window.y", this.getY());
        ini.writeBool(PROP_ACTIVE, this.snapLogger.isRunning());
        ini.writeInt(PROP_SNAPSHOT, INTERVALS[this.jSlider1.getValue()]);
        ini.writeString(PROP_SS_FORMAT, this.snapLogger.option.format.getExt());
        ini.writeInt(PROP_SNAPSHOT_COMPRESS, this.snapLogger.option.getCompress());
        ini.writeFloat(PROP_SS_SCALE, this.snapLogger.option.getScale());
        ini.updateFile(Komadoriki.appli);
    }

    void setTimerEnabled(boolean enabled, boolean save) {
        String title;
        this.jSlider1.setEnabled(!enabled);
        this.btnStart.setEnabled(!enabled);
        this.btnStop.setEnabled(enabled);
        this.popStart.setEnabled(this.btnStart.isEnabled());
        this.popStop.setEnabled(this.btnStop.isEnabled());
        if (enabled) {
            this.snapLogger.setInterval(INTERVALS[this.jSlider1.getValue()]);
            this.snapLogger.start();
            title = Komadoriki.appli.appName() + " - \u8a18\u9332\u4e2d";
            if (this.trayIcon != null) {
                this.trayIcon.setImage(INTERVAL_ICON_IMAGES[this.jSlider1.getValue()]);
            }
        } else {
            this.snapLogger.stop();
            title = Komadoriki.appli.appName() + " - \u505c\u6b62\u4e2d";
            if (this.trayIcon != null) {
                this.trayIcon.setImage(this.trayIconImage);
            }
        }
        this.setTitle(title);
        if (this.trayIcon != null) {
            this.trayIcon.setToolTip(title);
        }
        if (save) {
            try {
                this.configSave();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static void setSliderValue(JSlider slider, int value) {
        int p = 0;
        for (int i = 0; i < INTERVALS.length; ++i) {
            if (INTERVALS[i] < value) continue;
            p = i;
            break;
        }
        slider.setValue(p);
    }

    private void showErrorCouldntTakeScreenShot(Exception e) {
        String s = "\u30b9\u30af\u30ea\u30fc\u30f3\u30b7\u30e7\u30c3\u30c8\u306e\u64ae\u5f71\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002\n" + e.getMessage();
        JOptionPane.showMessageDialog(this, s, Komadoriki.appli.appName(), 0);
        e.printStackTrace();
    }

    private void initComponents() {
        this.popTrayIcon = new PopupMenu();
        this.popCaptureNow = new MenuItem();
        this.popCopyScreenShot = new MenuItem();
        this.popStart = new MenuItem();
        this.popStop = new MenuItem();
        this.popLog = new MenuItem();
        this.popScreenShotDirectory = new MenuItem();
        this.popConfig = new MenuItem();
        this.popExit = new MenuItem();
        this.jPanel1 = new JPanel();
        this.jSlider1 = new JSlider();
        this.lblCount = new JLabel();
        this.jPanel2 = new JPanel();
        this.btnStart = new JButton();
        this.btnStop = new JButton();
        this.btnLog = new JButton();
        this.btnConfig = new JButton();
        this.jMenuBar1 = new JMenuBar();
        this.jMenu2 = new JMenu();
        this.mnuScreenShotDirectory = new JMenuItem();
        this.jSeparator1 = new JSeparator();
        this.mnuAbout = new JMenuItem();
        this.mnuKazinaCom = new JMenuItem();
        this.jSeparator2 = new JSeparator();
        this.mnuExit = new JMenuItem();
        this.popTrayIcon.setLabel("PopupMenu");
        this.popCaptureNow.setLabel("\u4eca\u3059\u3050\u30b9\u30af\u30ea\u30fc\u30f3\u30b7\u30e7\u30c3\u30c8\u3092\u64ae\u308b");
        this.popCaptureNow.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainWindow2.this.popCaptureNowActionPerformed(evt);
            }
        });
        this.popTrayIcon.add(this.popCaptureNow);
        this.popCopyScreenShot.setLabel("\u4eca\u3059\u3050\u30b9\u30af\u30ea\u30fc\u30f3\u30b7\u30e7\u30c3\u30c8\u3092\u64ae\u3063\u3066\u30af\u30ea\u30c3\u30d7\u30dc\u30fc\u30c9\u306b\u30b3\u30d4\u30fc");
        this.popCopyScreenShot.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainWindow2.this.popCopyScreenShotActionPerformed(evt);
            }
        });
        this.popTrayIcon.add(this.popCopyScreenShot);
        this.popTrayIcon.addSeparator();
        this.popStart.setLabel("\u8a18\u9332\u958b\u59cb");
        this.popStart.setName("");
        this.popStart.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainWindow2.this.btnStartActionPerformed(evt);
            }
        });
        this.popTrayIcon.add(this.popStart);
        this.popStop.setLabel("\u505c\u6b62");
        this.popStop.setName("");
        this.popStop.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainWindow2.this.btnStopActionPerformed(evt);
            }
        });
        this.popTrayIcon.add(this.popStop);
        this.popTrayIcon.addSeparator();
        this.popLog.setLabel("\u8a18\u9332\u3092\u898b\u308b");
        this.popLog.setName("");
        this.popLog.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainWindow2.this.btnLogActionPerformed(evt);
            }
        });
        this.popTrayIcon.add(this.popLog);
        this.popScreenShotDirectory.setLabel("\u30b9\u30af\u30ea\u30fc\u30f3\u30b7\u30e7\u30c3\u30c8\u306e\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u3092\u958b\u304f");
        this.popScreenShotDirectory.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainWindow2.this.mnuScreenShotDirectoryActionPerformed(evt);
            }
        });
        this.popTrayIcon.add(this.popScreenShotDirectory);
        this.popConfig.setLabel("\u8a2d\u5b9a");
        this.popConfig.setName("");
        this.popConfig.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainWindow2.this.btnConfigActionPerformed(evt);
            }
        });
        this.popTrayIcon.add(this.popConfig);
        this.popTrayIcon.addSeparator();
        this.popExit.setLabel("\u7d42\u4e86");
        this.popExit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainWindow2.this.mnuExitActionPerformed(evt);
            }
        });
        this.popTrayIcon.add(this.popExit);
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                MainWindow2.this.formWindowClosing(evt);
            }
        });
        this.addWindowStateListener(new WindowStateListener(){

            public void windowStateChanged(WindowEvent evt) {
                MainWindow2.this.formWindowStateChanged(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("\u30b9\u30af\u30ea\u30fc\u30f3\u30b7\u30e7\u30c3\u30c8\u306e\u64ae\u5f71\u9593\u9694"));
        this.jSlider1.setMajorTickSpacing(1);
        this.jSlider1.setMaximum(10);
        this.jSlider1.setPaintLabels(true);
        this.jSlider1.setPaintTicks(true);
        this.jSlider1.setSnapToTicks(true);
        this.jSlider1.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                MainWindow2.this.jSlider1StateChanged(evt);
            }
        });
        this.lblCount.setText("jLabel1");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSlider1, -1, 464, Short.MAX_VALUE).addComponent(this.lblCount)).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jSlider1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblCount).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel2.setMinimumSize(new Dimension(128, 100));
        this.jPanel2.setPreferredSize(new Dimension(128, 136));
        this.jPanel2.setLayout(new GridLayout(0, 1, 0, 8));
        this.btnStart.setText("\u8a18\u9332\u958b\u59cb");
        this.btnStart.setMinimumSize(new Dimension(81, 12));
        this.btnStart.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainWindow2.this.btnStartActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.btnStart);
        this.btnStop.setText("\u505c\u6b62");
        this.btnStop.setMinimumSize(new Dimension(81, 12));
        this.btnStop.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainWindow2.this.btnStopActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.btnStop);
        this.btnLog.setText("\u8a18\u9332\u3092\u898b\u308b");
        this.btnLog.setMaximumSize(new Dimension(87, 28));
        this.btnLog.setMinimumSize(new Dimension(81, 12));
        this.btnLog.setPreferredSize(new Dimension(87, 28));
        this.btnLog.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainWindow2.this.btnLogActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.btnLog);
        this.btnConfig.setText("\u8a2d\u5b9a");
        this.btnConfig.setMinimumSize(new Dimension(81, 12));
        this.btnConfig.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainWindow2.this.btnConfigActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.btnConfig);
        this.jMenu2.setMnemonic('F');
        this.jMenu2.setText("\u30d5\u30a1\u30a4\u30eb(F)");
        this.mnuScreenShotDirectory.setMnemonic('O');
        this.mnuScreenShotDirectory.setText("\u30b9\u30af\u30ea\u30fc\u30f3\u30b7\u30e7\u30c3\u30c8\u306e\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u3092\u958b\u304f(O)");
        this.mnuScreenShotDirectory.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainWindow2.this.mnuScreenShotDirectoryActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.mnuScreenShotDirectory);
        this.jMenu2.add(this.jSeparator1);
        this.mnuAbout.setAccelerator(KeyStroke.getKeyStroke(112, 0));
        this.mnuAbout.setMnemonic('A');
        this.mnuAbout.setText("\u30d0\u30fc\u30b8\u30e7\u30f3\u60c5\u5831(A)...");
        this.mnuAbout.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainWindow2.this.mnuAboutActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.mnuAbout);
        this.mnuKazinaCom.setMnemonic('k');
        this.mnuKazinaCom.setText("kazina.com\u3078");
        this.mnuKazinaCom.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainWindow2.this.mnuKazinaComActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.mnuKazinaCom);
        this.jMenu2.add(this.jSeparator2);
        this.mnuExit.setMnemonic('X');
        this.mnuExit.setText("\u7d42\u4e86(X)");
        this.mnuExit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainWindow2.this.mnuExitActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.mnuExit);
        this.jMenuBar1.add(this.jMenu2);
        this.setJMenuBar(this.jMenuBar1);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addGap(18, 18, 18).addComponent(this.jPanel2, -2, 128, -2).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -2, -1, -2).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        this.pack();
    }

    private void mnuAboutActionPerformed(ActionEvent evt) {
        Komadoriki.appli.aboutDialog(this);
    }

    private void mnuKazinaComActionPerformed(ActionEvent evt) {
        KzUtils.kazinaCom();
    }

    private void mnuExitActionPerformed(ActionEvent evt) {
        System.exit(0);
    }

    private void btnConfigActionPerformed(ActionEvent evt) {
        if (ConfigDialog2.execute(this, this.snapLogger)) {
            try {
                this.configSave();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void btnLogActionPerformed(ActionEvent evt) {
        LogViewDialog dlg = new LogViewDialog((Frame)this, true);
        if (dlg.getDateCount() == 0) {
            dlg.dispose();
            JOptionPane.showMessageDialog(this, MSG_NO_LOG, Komadoriki.appli.appName(), 2);
        } else {
            dlg.setVisible(true);
        }
    }

    private void btnStartActionPerformed(ActionEvent evt) {
        this.setTimerEnabled(true, true);
    }

    private void btnStopActionPerformed(ActionEvent evt) {
        this.setTimerEnabled(false, true);
    }

    private void formWindowClosing(WindowEvent evt) {
        try {
            this.configSave();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void formWindowStateChanged(WindowEvent evt) {
        if ((evt.getNewState() & 1) != 0) {
            this.setVisible(false);
            this.setExtendedState(0);
        }
    }

    private void jSlider1StateChanged(ChangeEvent evt) {
        int a = INTERVALS[this.jSlider1.getValue()];
        int perDay = 86400 / a;
        int perWeek = perDay * 7;
        String s = "\u4e00\u65e5\u306b " + perDay + " \u679a\u3001\u4e00\u9031\u9593\u3067 " + perWeek + " \u679a\u64ae\u5f71\u3057\u307e\u3059\u3002";
        this.lblCount.setText(s);
    }

    private void mnuScreenShotDirectoryActionPerformed(ActionEvent evt) {
        File dirToday = new File(logDirectory, ScreenShotLogger.getDateDirectoryName(new BenriDate()));
        if (!dirToday.exists()) {
            dirToday = logDirectory;
        }
        if (dirToday.exists() && dirToday.isDirectory()) {
            Desktop desktop = Desktop.getDesktop();
            try {
                desktop.open(dirToday);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            String s = "\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u304c\u898b\u4ed8\u304b\u308a\u307e\u305b\u3093\u3002\n" + dirToday.getAbsolutePath();
            JOptionPane.showMessageDialog(this, s, Komadoriki.appli.appName(), 0);
        }
    }

    private void popCaptureNowActionPerformed(ActionEvent evt) {
        try {
            this.snapLogger.captureNow(false);
        }
        catch (Exception e) {
            this.showErrorCouldntTakeScreenShot(e);
        }
    }

    private void popCopyScreenShotActionPerformed(ActionEvent evt) {
        try {
            BufferedImage img = ScreenShotLogger.takeScreenShot();
            KzImageSelection.copyImageToClipboard(this, img);
        }
        catch (Exception e) {
            this.showErrorCouldntTakeScreenShot(e);
        }
    }
}

