/*
 * Decompiled with CFR 0.152.
 */
package com.kazina.j;

import com.kazina.j.KzApplication;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import javax.swing.JFrame;

public class KzIniFile {
    private String fileName;
    private Properties prop = new Properties();

    public KzIniFile(String _fileName) throws IOException {
        this.fileName = _fileName;
        File f = new File(this.fileName);
        if (f.exists() && f.isFile()) {
            try {
                FileInputStream in = new FileInputStream(f);
                this.prop.load(in);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    public void updateFile(KzApplication appli) throws IOException {
        File f = new File(this.fileName).getParentFile();
        f.mkdirs();
        try {
            String header = appli.appNameAscii() + String.format(" ver%.2f", Float.valueOf(appli.appVersion()));
            this.prop.store(new FileOutputStream(this.fileName), header);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            throw e;
        }
    }

    public void writeInt(String ident, int value) {
        this.prop.setProperty(ident, "" + value);
    }

    public void writeByte(String ident, byte value) {
        this.prop.setProperty(ident, "" + value);
    }

    public void writeFloat(String ident, float value) {
        this.prop.setProperty(ident, "" + value);
    }

    public void writeDouble(String ident, double value) {
        this.prop.setProperty(ident, "" + value);
    }

    public void writeBool(String ident, boolean value) {
        this.prop.setProperty(ident, "" + value);
    }

    public void writeString(String ident, String value) {
        this.prop.setProperty(ident, value);
    }

    public void writeWindowPos(String ident, JFrame value) {
        this.writeInt(ident + ".x", value.getX());
        this.writeInt(ident + ".y", value.getY());
        this.writeInt(ident + ".Width", value.getWidth());
        this.writeInt(ident + ".Height", value.getHeight());
    }

    public void readWindowPos(String ident, JFrame value) {
        int x = this.readInt(ident + ".x", value.getX());
        int y = this.readInt(ident + ".y", value.getY());
        int w = this.readInt(ident + ".Width", value.getWidth());
        int h = this.readInt(ident + ".Height", value.getHeight());
        value.setBounds(x, y, w, h);
    }

    public int readInt(String ident, int defaultValue) {
        String temp = this.prop.getProperty(ident);
        if (temp == null) {
            return defaultValue;
        }
        return Integer.parseInt(temp);
    }

    public byte readByte(String ident, byte defaultValue) {
        String temp = this.prop.getProperty(ident);
        if (temp == null) {
            return defaultValue;
        }
        return Byte.parseByte(temp);
    }

    public float readFloat(String ident, float defaultValue) {
        String temp = this.prop.getProperty(ident);
        if (temp == null) {
            return defaultValue;
        }
        return Float.parseFloat(temp);
    }

    public double readDouble(String ident, double defaultValue) {
        String temp = this.prop.getProperty(ident);
        if (temp == null) {
            return defaultValue;
        }
        return Double.parseDouble(temp);
    }

    public boolean readBool(String ident, boolean defaultValue) {
        String temp = this.prop.getProperty(ident);
        if (temp == null) {
            return defaultValue;
        }
        return Boolean.parseBoolean(temp);
    }

    public String readString(String ident, String defaultValue) {
        String temp = this.prop.getProperty(ident);
        if (temp == null) {
            return defaultValue;
        }
        return temp;
    }

    public boolean keyExists(String ident) {
        return this.prop.getProperty(ident) != null;
    }
}

