/*
 * Decompiled with CFR 0.152.
 */
package com.kazina.j;

import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.InputMap;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class KzUtils {
    public static final JMenu createMenu(String caption, char mnemonic) {
        JMenu menu = new JMenu(caption);
        menu.setMnemonic(mnemonic);
        return menu;
    }

    public static final JMenuItem createMenuItem(String caption, char mnemonic, KeyStroke stroke, ActionListener actionListener, String command) {
        JMenuItem item = new JMenuItem(caption);
        item.setMnemonic(mnemonic);
        item.setAccelerator(stroke);
        item.addActionListener(actionListener);
        if (command != null) {
            item.setActionCommand(command);
        }
        return item;
    }

    public static final void setSystemLookAndFeel() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (UnsupportedLookAndFeelException e) {
            e.printStackTrace();
        }
    }

    public static final String extractFileExt(String fileName) {
        int dot = fileName.indexOf(46);
        if (dot == -1) {
            return "";
        }
        return fileName.substring(dot + 1);
    }

    public static final String includingPathDelimiter(String fileName) {
        if (fileName.endsWith(File.separator)) {
            return fileName;
        }
        return fileName + File.separator;
    }

    public static final String lowerCaseFileName(String fileName) {
        return fileName.toLowerCase(Locale.ENGLISH);
    }

    public static String changeFileExt(String fileName, String extWithDot) {
        return KzUtils.extractFileExt(fileName) + extWithDot;
    }

    public static String toHexColor(Color color) {
        int r = color.getRed();
        int g = color.getGreen();
        int b = color.getBlue();
        return "#" + String.format("%02x%02x%02x", r, g, b);
    }

    public static final String smartByteSize(long size) {
        String[] units = new String[]{"E", "P", "T", "G", "M", "K"};
        String result = null;
        for (int i = units.length; i >= 1; --i) {
            long a = 1L;
            for (int j = 0; j < i; ++j) {
                a *= 1024L;
            }
            if (size < a) continue;
            double value = (double)size / (double)a;
            BigDecimal big = new BigDecimal(String.valueOf(value));
            value = big.setScale(1, 4).doubleValue();
            result = value + " " + units[units.length - i] + "Bytes";
            break;
        }
        if (result == null) {
            result = size + " bytes";
        }
        return result;
    }

    public static final String smartPercentage(double percentage) {
        String s = "" + percentage * 100.0;
        int posDot = s.indexOf(46);
        if (percentage >= 1.0) {
            BigDecimal big = new BigDecimal(s);
            return big.setScale(1, 4).toString();
        }
        int firstZero = -1;
        for (int c = posDot + 1; c < s.length(); ++c) {
            if (s.charAt(c) == '0') continue;
            firstZero = c;
            break;
        }
        if (firstZero == -1) {
            return s;
        }
        BigDecimal big = new BigDecimal(s);
        return big.setScale(firstZero, 4).toString();
    }

    public static final File directorySelectDialog(Component owner, String initialDir) {
        JFileChooser chooser = new JFileChooser(initialDir);
        chooser.setFileSelectionMode(1);
        int selected = chooser.showOpenDialog(owner);
        if (selected == 0) {
            return chooser.getSelectedFile();
        }
        return null;
    }

    public static final void kazinaCom() {
        Desktop desktop = Desktop.getDesktop();
        try {
            desktop.browse(new URI("http://kazina.com/"));
        }
        catch (URISyntaxException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static final void disposeWhenESC(JDialog dlg) {
        InputMap imap = dlg.getRootPane().getInputMap(2);
        imap.put(KeyStroke.getKeyStroke(27, 0), "escape");
        dlg.getRootPane().getActionMap().put("escape", new DialogCloseAction(dlg));
    }

    private static final class DialogCloseAction
    extends AbstractAction {
        private final JDialog dlg;

        public DialogCloseAction(JDialog _dialog) {
            this.dlg = _dialog;
        }

        public void actionPerformed(ActionEvent arg0) {
            this.dlg.dispose();
        }
    }
}

